<?php  
            include_once( $_SERVER['DOCUMENT_ROOT']."/static/includes/common.inc.php" );
            do_html_header("Documentation");
        ?><div id="content">
<div class="navheader">
<table width="100%" summary="Navigation header"><tr>
<td width="20%" align="left">
<a accesskey="p" href="cli-pegasus-submit-dag.php">Prev</a> </td>
<td width="60%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="20%" align="right"> <a accesskey="n" href="cli-pegasus-tc-client.php">Next</a>
</td>
</tr></table>
<hr>
</div>
<div lang="en" class="refentry" title="pegasus-submitdir">
<a name="cli-pegasus-submitdir"></a><div class="titlepage"></div>
<div class="refnamediv">
<h2>Name</h2>
<p>pegasus-submitdir — Manage a workflow submit directory.</p>
</div>
<div class="refsynopsisdiv" title="Synopsis">
<a name="pegasus-submitdir_synopsis"></a><h2>Synopsis</h2>
<div class="blockquote"><blockquote class="blockquote"><div class="literallayout"><p><span class="strong"><strong>pegasus-submitdir</strong></span> <span class="emphasis"><em>COMMAND</em></span> [options] <span class="emphasis"><em>SUBMITDIR</em></span></p></div></blockquote></div>
</div>
<div class="refsect1" title="Description">
<a name="pegasus-submitdir_description"></a><h2>Description</h2>
<p><span class="strong"><strong>pegasus-submitdir</strong></span> is used to manage submit directories generated by the
Pegasus planner.</p>
<p>The <span class="strong"><strong>archive</strong></span> command significantly reduces the size of workflow submit
directories by compressing the data in a way such that it remains accessible
to tools such as pegasus-statistics, pegasus-plots, and pegasus-analyzer.</p>
<p>The <span class="strong"><strong>extract</strong></span> command reverses the effect of the <span class="strong"><strong>archive</strong></span> command.</p>
<p>The <span class="strong"><strong>move</strong></span> command relocates a submit directory and updates relevant pointers
in the database so that it can still be accessed through the dashboard.</p>
<p>The <span class="strong"><strong>delete</strong></span> command removes the submit directory and cleans up any associated
records in the user’s master database.</p>
</div>
<div class="refsect1" title="Commands">
<a name="pegasus-submitdir_commands"></a><h2>Commands</h2>
<div class="variablelist"><dl>
<dt><span class="term">
<span class="strong"><strong>archive</strong></span> SUBMITDIR
</span></dt>
<dd>
    Compresses a workflow submit directory in a way that allows
    pegasus-dashboard, pegasus-statistics, pegasus-plots, and
    pegasus-analyzer to keep working. It creates a gzipped tar archive of
    the submit files and logs that excludes files such as the workflow
    database, braindump file, and monitord logs, which are used by pegasus
    reporting tools.
</dd>
<dt><span class="term">
<span class="strong"><strong>extract</strong></span> SUBMITDIR
</span></dt>
<dd>
    Uncompresses a previously archived submit directory. This option returns
    the submit directory to the state it was before <span class="strong"><strong>pegasus-submitdir archive</strong></span>
    was applied to it.
</dd>
<dt><span class="term">
<span class="strong"><strong>move</strong></span> SUBMITDIR DEST
</span></dt>
<dd>
    Move a workflow submit dir from SUBMITDIR to DEST. This operation updates
    the relevant database records so that the dashboard continues to function.
    DEST can be either an existing directory, in which case the submit dir
    becomes a subdirectory, or a new path, in which case the submit dir is
    renamed. <span class="strong"><strong>IMPORTANT</strong></span> This operation should only be performed on
    workflows that will not be resubmitted in the future. Moving a workflow
    does not update absolute paths in any of the submit files, so after a
    workflow has been moved it is not possible to rerun it.
</dd>
<dt><span class="term">
<span class="strong"><strong>delete</strong></span> SUBMITDIR
</span></dt>
<dd>
    Delete a workflow submit dir. This operation removes all related records
    from the user’s master database, including ensemble manager records.
    Deleted workflows do not appear in the dashboard.
</dd>
</dl></div>
</div>
<div class="refsect1" title="Global Options">
<a name="pegasus-submitdir_global_options"></a><h2>Global Options</h2>
<div class="variablelist"><dl>
<dt>
<span class="term">
<span class="strong"><strong>-h</strong></span>
, </span><span class="term">
<span class="strong"><strong>--help</strong></span>
</span>
</dt>
<dd>
Prints a usage summary with all the available command-line options.
</dd>
</dl></div>
</div>
<div class="refsect1" title="Authors">
<a name="pegasus-submitdir_authors"></a><h2>Authors</h2>
<p>Gideon Juve &lt;<a class="ulink" href="mailto:gideon@isi.edu" target="_top">gideon@isi.edu</a>&gt;</p>
<p>Pegasus Team <a class="ulink" href="http://pegasus.isi.edu" target="_top">http://pegasus.isi.edu</a></p>
</div>
</div>
<div class="navfooter">
<hr>
<table width="100%" summary="Navigation footer">
<tr>
<td width="40%" align="left">
<a accesskey="p" href="cli-pegasus-submit-dag.php">Prev</a> </td>
<td width="20%" align="center"><a accesskey="u" href="cli.php">Up</a></td>
<td width="40%" align="right"> <a accesskey="n" href="cli-pegasus-tc-client.php">Next</a>
</td>
</tr>
<tr>
<td width="40%" align="left" valign="top">pegasus-submit-dag </td>
<td width="20%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="40%" align="right" valign="top"> pegasus-tc-client</td>
</tr>
</table>
</div>
</div><?php  
            do_html_footer();
        ?>
