<?php  
            include_once( $_SERVER['DOCUMENT_ROOT']."/static/includes/common.inc.php" );
            do_html_header("Documentation");
        ?><div id="content">
<div class="navheader">
<table width="100%" summary="Navigation header"><tr>
<td width="20%" align="left">
<a accesskey="p" href="properties.php">Prev</a> </td>
<td width="60%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="20%" align="right"> <a accesskey="n" href="condor_dagman_file.php">Next</a>
</td>
</tr></table>
<hr>
</div>
<div class="chapter">
<div class="titlepage"><div><div><h1 class="title">
<a name="submit_directory"></a>Chapter 13. Submit Directory Details</h1></div></div></div>
<div class="toc"><dl class="toc">
<dt><span class="section"><a href="submit_directory.php#submit_directory_layout">13.1. Layout</a></span></dt>
<dt><span class="section"><a href="condor_dagman_file.php">13.2. Condor DAGMan File</a></span></dt>
<dt><span class="section"><a href="kickstart_xml_record.php">13.3. Kickstart XML Record</a></span></dt>
<dt><span class="section"><a href="jobstate_log_file.php">13.4. Jobstate.Log File</a></span></dt>
<dt><span class="section"><a href="braindump_file.php">13.5. Braindump File</a></span></dt>
<dt><span class="section"><a href="static_bp_file.php">13.6. Pegasus static.bp File</a></span></dt>
</dl></div>
<p>This chapter describes the submit directory content after Pegasus has
  planned a workflow. Pegasus takes in an abstract workflow ( DAX ) and
  generates an executable workflow (DAG) in the submit directory.</p>
<p>This document also describes the various Replica Selection Strategies
  in Pegasus.</p>
<div class="section">
<div class="titlepage"><div><div><h2 class="title" style="clear: both">
<a name="submit_directory_layout"></a>13.1. Layout</h2></div></div></div>
<p>Each executable workflow is associated with a submit directory, and
    includes the following:</p>
<div class="orderedlist"><ol class="orderedlist" type="1">
<li class="listitem">
<p><span class="bold"><strong>&lt;daxlabel-daxindex&gt;.dag
        </strong></span></p>
<p>This is the Condor DAGMman dag file corresponding to the
        executable workflow generated by Pegasus. The dag file describes the
        edges in the DAG and information about the jobs in the DAG. Pegasus
        generated .dag file usually contains the following information for
        each job</p>
<div class="orderedlist"><ol class="orderedlist" type="a">
<li class="listitem"><p>The job submit file for each job in the DAG.</p></li>
<li class="listitem"><p>The post script that is to be invoked when a job completes.
            This is usually located at <span class="bold"><strong>$PEGASUS_HOME/bin/exitpost</strong></span> and parses the
            kickstart record in the job's<span class="bold"><strong>.out
            file</strong></span> and determines the exitcode.</p></li>
<li class="listitem"><p>JOB RETRY - the number of times the job is to be retried in
            case of failure. In Pegasus, the job postscript exits with a non
            zero exitcode if it determines a failure occurred.</p></li>
</ol></div>
</li>
<li class="listitem">
<p><span class="bold"><strong>&lt;daxlabel-daxindex&gt;.dag.dagman.out</strong></span></p>
<p>When a DAG ( .dag file ) is executed by Condor DAGMan , the
        DAGMan writes out it's output to the <span class="bold"><strong>&lt;daxlabel-daxindex&gt;.dag.dagman.out file</strong></span> .
        This file tells us the progress of the workflow, and can be used to
        determine the status of the workflow. Most of pegasus tools mine the
        <span class="bold"><strong>dagman.out</strong></span> or <span class="bold"><strong>jobstate.log</strong></span> to determine the progress of the
        workflows.</p>
</li>
<li class="listitem">
<p><span class="bold"><strong>&lt;daxlabel-daxindex&gt;.static.bp</strong></span></p>
<p>This file contains netlogger events that link jobs in the DAG
        with the jobs in the DAX. This file is parsed by pegasus-monitord when
        a workflow starts and populated to the stampede backend.</p>
</li>
<li class="listitem">
<p><span class="bold"><strong>&lt;daxlabel-daxindex&gt;.notify</strong></span></p>
<p>This file contains all the notifications that need to be set for
        the workflow and the jobs in the executable workflow. The format of
        notify file is described <a class="link" href="notifications.php#pegasus_notify_file" title="6.4.2. Notify File created by Pegasus in the submit directory">here</a></p>
</li>
<li class="listitem">
<p><span class="bold"><strong>&lt;daxlabel-daxindex&gt;.replica.store</strong></span></p>
<p>This is a file based replica catalog, that only lists file
        locations are mentioned in the DAX.</p>
</li>
<li class="listitem">
<p><span class="bold"><strong>&lt;daxlabel-daxindex&gt;.dot
        </strong></span></p>
<p>Pegasus creates a dot file for the executable workflow in
        addition to the .dag file. This can be used to visualize the
        executable workflow using the dot program.</p>
</li>
<li class="listitem">
<p><span class="bold"><strong>&lt;job&gt;.sub</strong></span></p>
<p>Each job in the executable workflow is associated with it's own
        submit file. The submit file tells Condor how to execute the
        job.</p>
</li>
<li class="listitem">
<p><span class="bold"><strong>&lt;job&gt;.out.00n</strong></span></p>
<p>The stdout of the executable referred in the job submit file. In
        Pegasus, most jobs are launched via kickstart. Hence, this file
        contains the kickstart XML provenance record that captures runtime
        provenance on the remote node where the job was executed. n varies
        from 1-N where N is the JOB RETRY value in the .dag file. The exitpost
        executable is invoked on the &lt;job&gt;.out file and it moves the
        &lt;job&gt;.out to &lt;job&gt;.out.00n so that the the job's .out
        files are preserved across retries.</p>
</li>
<li class="listitem">
<p><span class="bold"><strong>&lt;job&gt;.err.00n</strong></span></p>
<p>The stderr of the executable referred in the job submit file. In
        case of Pegasus, mostly the jobs are launched via kickstart. Hence,
        this file contains stderr of kickstart. This is usually empty unless
        there in an error in kickstart e.g. kickstart segfaults , or kickstart
        location specified in the submit file is incorrect. The exitpost
        executable is invoked on the <span class="bold"><strong>&lt;job&gt;.out</strong></span> file and it moves the <span class="bold"><strong> &lt;job&gt;.err to &lt;job&gt;.err.00n</strong></span> so that
        the the job's <span class="bold"><strong>.out</strong></span> files are
        preserved across retries.</p>
</li>
<li class="listitem">
<p><span class="bold"><strong>jobstate.log</strong></span></p>
<p>The jobstate.log file is written out by the pegasus-monitord
        daemon that is launched when a workflow is submitted for execution by
        pegasus-run. The pegasus-monitord daemon parses the dagman.out file
        and writes out the jobstate.log that is easier to parse. The
        jobstate.log captures the various states through which a job goes
        during the workflow. There are other monitoring related files that are
        explained in the monitoring <a class="link" href="monitoring.php#monitoring-files" title="6.5.1.2. Monitoring related files in the workflow directory">chapter</a>.</p>
</li>
<li class="listitem">
<p><span class="bold"><strong>braindump.txt </strong></span></p>
<p>Contains information about pegasus version, dax file, dag file,
        dax label.</p>
</li>
</ol></div>
</div>
</div>
<div class="navfooter">
<hr>
<table width="100%" summary="Navigation footer">
<tr>
<td width="40%" align="left">
<a accesskey="p" href="properties.php">Prev</a> </td>
<td width="20%" align="center"> </td>
<td width="40%" align="right"> <a accesskey="n" href="condor_dagman_file.php">Next</a>
</td>
</tr>
<tr>
<td width="40%" align="left" valign="top">12.3. Properties </td>
<td width="20%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="40%" align="right" valign="top"> 13.2. Condor DAGMan File</td>
</tr>
</table>
</div>
</div><?php  
            do_html_footer();
        ?>
