<?php  
            include_once( $_SERVER['DOCUMENT_ROOT']."/static/includes/common.inc.php" );
            do_html_header("Documentation");
        ?><div id="content">
<div class="navheader">
<table width="100%" summary="Navigation header"><tr>
<td width="20%" align="left">
<a accesskey="p" href="migrating_from_3x.php">Prev</a> </td>
<td width="60%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="20%" align="right"> <a accesskey="n" href="portable_code.php">Next</a>
</td>
</tr></table>
<hr>
</div>
<div class="section" title="16.3. Migrating From Pegasus 2.X to Pegasus 3.X">
<div class="titlepage"><div><div><h2 class="title" style="clear: both">
<a name="migrating_from_2x"></a>16.3. Migrating From Pegasus 2.X to Pegasus 3.X</h2></div></div></div>
<div class="toc"><dl>
<dt><span class="section"><a href="migrating_from_2x.php#idp35602672">16.3.1. PEGASUS_HOME and Setup Scripts</a></span></dt>
<dt><span class="section"><a href="migrating_from_2x.php#idp35606656">16.3.2. Changes to Schemas and Catalog Formats</a></span></dt>
<dt><span class="section"><a href="migrating_from_2x.php#idp42674336">16.3.3. Properties and Profiles Simplification</a></span></dt>
<dt><span class="section"><a href="migrating_from_2x.php#idp36699936">16.3.4. Transfers Simplification</a></span></dt>
<dt><span class="section"><a href="migrating_from_2x.php#idp45010848">16.3.5. Clients in bin directory</a></span></dt>
</dl></div>
<p>With Pegasus 3.0 effort has been made to simplify configuration.
    This chapter is for existing users of Pegasus who use Pegasus 2.x to run
    their workflows and walks through the steps to move to using Pegasus
    3.0</p>
<div class="section" title="16.3.1. PEGASUS_HOME and Setup Scripts">
<div class="titlepage"><div><div><h3 class="title">
<a name="idp35602672"></a>16.3.1. PEGASUS_HOME and Setup Scripts</h3></div></div></div>
<p>Earlier versions of Pegasus required users to have the environment
      variable PEGASUS_HOME set and to source a setup file
      $PEGASUS_HOME/setup.sh | $PEGASUS_HOME/setup.csh before running Pegasus
      to setup CLASSPATH and other variables.</p>
<p>Starting with Pegasus 3.0 this is no longer required. The above
      paths are automaticallly determined by the Pegasus tools when they are
      invoked.</p>
<p>All the users need to do is to set the PATH variable to pick up
      the pegasus executables from the bin directory.</p>
<pre class="programlisting">$ <span class="bold"><strong>export PATH=/some/install/pegasus-3.0.0/bin:$PATH</strong></span></pre>
</div>
<div class="section" title="16.3.2. Changes to Schemas and Catalog Formats">
<div class="titlepage"><div><div><h3 class="title">
<a name="idp35606656"></a>16.3.2. Changes to Schemas and Catalog Formats</h3></div></div></div>
<div class="section" title="16.3.2.1. DAX Schema">
<div class="titlepage"><div><div><h4 class="title">
<a name="idp43807520"></a>16.3.2.1. DAX Schema</h4></div></div></div>
<p>Pegasus 3.0 by default now parses DAX documents conforming to
        the DAX Schema 3.2 available <a class="ulink" href="http://pegasus.isi.edu/wms/docs/schemas/dax-3.2/dax-3.2.xsd" target="_top">here</a> and is explained in detail in the chapter on
        API references.</p>
<p>Starting Pegasus 3.0 , DAX generation API's are provided in
        Java/Python and Perl for users to use in their DAX Generators. The use
        of API's is highly encouraged. Support for the old DAX schema's has
        been deprecated and will be removed in a future version.</p>
<p>For users, who still want to run using the old DAX formats i.e
        3.0 or earlier, can for the time being set the following property in
        the properties and point it to dax-3.0 xsd of the installation.</p>
<pre class="programlisting"><span class="bold"><strong>pegasus.schema.dax  /some/install/pegasus-3.0/etc/dax-3.0.xsd</strong></span></pre>
</div>
<div class="section" title="16.3.2.2. Site Catalog Format">
<div class="titlepage"><div><div><h4 class="title">
<a name="idp50621648"></a>16.3.2.2. Site Catalog Format</h4></div></div></div>
<p>Pegasus 3.0 by default now parses Site Catalog format conforming
        to the SC schema 3.0 ( XML3 ) available <a class="ulink" href="http://pegasus.isi.edu/wms/docs/schemas/dax-3.2/dax-3.2.xsd" target="_top">here</a> and is explained in detail in the chapter on
        Catalogs.</p>
<p>Pegasus 3.0 comes with a pegasus-sc-converter that will convert
        users old site catalog ( XML ) to the XML3 format. Sample usage is
        given below.</p>
<pre class="programlisting"><span class="bold"><strong>$ pegasus-sc-converter -i sample.sites.xml -I XML -o sample.sites.xml3 -O XML3
</strong></span>
2010.11.22 12:55:14.169 PST:   Written out the converted file to sample.sites.xml3 
</pre>
<p>To use the converted site catalog, in the properties do the
        following</p>
<div class="orderedlist"><ol class="orderedlist" type="1">
<li class="listitem"><p>unset pegasus.catalog.site or set pegasus.catalog.site to
            XML3</p></li>
<li class="listitem"><p>point pegasus.catalog.site.file to the converted site
            catalog</p></li>
</ol></div>
</div>
<div class="section" title="16.3.2.3. Transformation Catalog Format">
<div class="titlepage"><div><div><h4 class="title">
<a name="idp41493680"></a>16.3.2.3. Transformation Catalog Format</h4></div></div></div>
<p>Pegasus 3.0 by default now parses a file based multiline textual
        format of a Transformation Catalog. The new Text format is explained
        in detail in the chapter on Catalogs.</p>
<p>Pegasus 3.0 comes with a pegasus-tc-converter that will convert
        users old transformation catalog ( File ) to the Text format. Sample
        usage is given below.</p>
<pre class="programlisting"><span class="bold"><strong>$ pegasus-tc-converter -i sample.tc.data -I File -o sample.tc.text -O Text
</strong></span>
2010.11.22 12:53:16.661 PST:   Successfully converted Transformation Catalog from File to Text 
2010.11.22 12:53:16.666 PST:   The output transfomation catalog is in file  /lfs1/software/install/pegasus/pegasus-3.0.0cvs/etc/sample.tc.text 
</pre>
<p>To use the converted transformation catalog, in the properties
        do the following</p>
<div class="orderedlist"><ol class="orderedlist" type="1">
<li class="listitem"><p>unset pegasus.catalog.transformation or set
            pegasus.catalog.transformation to Text</p></li>
<li class="listitem"><p>point pegasus.catalog.transformation.file to the converted
            transformation catalog</p></li>
</ol></div>
</div>
</div>
<div class="section" title="16.3.3. Properties and Profiles Simplification">
<div class="titlepage"><div><div><h3 class="title">
<a name="idp42674336"></a>16.3.3. Properties and Profiles Simplification</h3></div></div></div>
<p>Starting with Pegasus 3.0 all profiles can be specified in the
      properties file. Profiles specified in the properties file have the
      lowest priority. Profiles are explained in the detail in the<a class="link" href="configuration.php" title="Chapter 12. Configuration"> configuration</a> chapter. As a result of
      this a lot of existing Pegasus Properties were replaced by profiles. The
      table below lists the properties removed and the new profile based
      names.</p>
<div class="table">
<a name="idp42676624"></a><p class="title"><b>Table 16.3. Table 1: Property Keys removed and their Profile based
        replacement</b></p>
<div class="table-contents"><table summary="Table 1: Property Keys removed and their Profile based
        replacement" border="1">
<colgroup>
<col>
<col>
</colgroup>
<tbody>
<tr>
<td><span class="bold"><strong>Old Property Key</strong></span></td>
<td><span class="bold"><strong>New Property Key</strong></span></td>
</tr>
<tr>
<td>pegasus.local.env</td>
<td>no replacement. Specify env profiles for local site in
              the site catalog</td>
</tr>
<tr>
<td>pegasus.condor.release</td>
<td>condor.periodic_release</td>
</tr>
<tr>
<td>pegasus.condor.remove</td>
<td>condor.periodic_remove</td>
</tr>
<tr>
<td>pegasus.job.priority</td>
<td>condor.priority</td>
</tr>
<tr>
<td>pegasus.condor.output.stream</td>
<td>pegasus.condor.output.stream</td>
</tr>
<tr>
<td>pegasus.condor.error.stream</td>
<td>condor.stream_error</td>
</tr>
<tr>
<td>pegasus.dagman.retry</td>
<td>dagman.retry</td>
</tr>
<tr>
<td>pegasus.exitcode.impl</td>
<td>dagman.post</td>
</tr>
<tr>
<td>pegasus.exitcode.scope</td>
<td>dagman.post.scope</td>
</tr>
<tr>
<td>pegasus.exitcode.arguments</td>
<td>dagman.post.arguments</td>
</tr>
<tr>
<td>pegasus.exitcode.path.*</td>
<td>dagman.post.path.*</td>
</tr>
<tr>
<td>pegasus.dagman.maxpre</td>
<td>dagman.maxpre</td>
</tr>
<tr>
<td>pegasus.dagman.maxpost</td>
<td>dagman.maxpost</td>
</tr>
<tr>
<td>pegasus.dagman.maxidle</td>
<td>dagman.maxidle</td>
</tr>
<tr>
<td>pegasus.dagman.maxjobs</td>
<td>dagman.maxjobs</td>
</tr>
<tr>
<td>pegasus.remote.scheduler.min.maxwalltime</td>
<td>globus.maxwalltime</td>
</tr>
<tr>
<td>pegasus.remote.scheduler.min.maxtime</td>
<td>globus.maxtime</td>
</tr>
<tr>
<td>pegasus.remote.scheduler.min.maxcputime</td>
<td>globus.maxcputime</td>
</tr>
<tr>
<td>pegasus.remote.scheduler.queues</td>
<td>globus.queue</td>
</tr>
</tbody>
</table></div>
</div>
<br class="table-break"><div class="section" title="16.3.3.1. Profile Keys for Clustering">
<div class="titlepage"><div><div><h4 class="title">
<a name="idp34222528"></a>16.3.3.1. Profile Keys for Clustering</h4></div></div></div>
<p>The pegasus profile keys for job clustering were <span class="bold"><strong>renamed</strong></span>. The following table lists the old and
        the new names for the profile keys.</p>
<div class="table">
<a name="idp32449056"></a><p class="title"><b>Table 16.4. Table 2: Old and New Names For Job Clustering Profile
          Keys</b></p>
<div class="table-contents"><table summary="Table 2: Old and New Names For Job Clustering Profile
          Keys" border="1">
<colgroup>
<col>
<col>
</colgroup>
<tbody>
<tr>
<td><span class="bold"><strong>Old Pegasus Profile
                Key</strong></span></td>
<td><span class="bold"><strong>New Pegasus Profile
                Key</strong></span></td>
</tr>
<tr>
<td>collapse</td>
<td>clusters.size</td>
</tr>
<tr>
<td>bundle</td>
<td>clusters.num</td>
</tr>
</tbody>
</table></div>
</div>
<br class="table-break">
</div>
</div>
<div class="section" title="16.3.4. Transfers Simplification">
<div class="titlepage"><div><div><h3 class="title">
<a name="idp36699936"></a>16.3.4. Transfers Simplification</h3></div></div></div>
<p>Pegasus 3.0 has a new default transfer client pegasus-transfer
      that is invoked by default for first level and second level staging. The
      pegasus-transfer client is a python based wrapper around various
      transfer clients like globus-url-copy, lcg-copy, wget, cp, ln .
      pegasus-transfer looks at source and destination url and figures out
      automatically which underlying client to use. pegasus-transfer is
      distributed with the PEGASUS and can be found in the bin subdirectory
      .</p>
<p>Also, the Bundle Transfer refiner has been made the default for
      pegasus 3.0. Most of the users no longer need to set any transfer
      related properties. The names of the profiles keys that control the
      Bundle Transfers have been changed . The following table lists the old
      and the new names for the Pegasus Profile Keys and are explained in
      details in the Profiles Chapter.</p>
<div class="table">
<a name="idp37144800"></a><p class="title"><b>Table 16.5. Table 3: Old and New Names For Transfer Bundling Profile
        Keys</b></p>
<div class="table-contents"><table summary="Table 3: Old and New Names For Transfer Bundling Profile
        Keys" border="1">
<colgroup>
<col>
<col>
</colgroup>
<tbody>
<tr>
<td><span class="bold"><strong>Old Pegasus Profile
              Key</strong></span></td>
<td><span class="bold"><strong>New Pegasus Profile
              Keys</strong></span></td>
</tr>
<tr>
<td>bundle.stagein</td>
<td>stagein.clusters | stagein.local.clusters |
              stagein.remote.clusters</td>
</tr>
<tr>
<td>bundle.stageout</td>
<td>stageout.clusters | stageout.local.clusters |
              stageout.remote.clusters</td>
</tr>
</tbody>
</table></div>
</div>
<br class="table-break"><div class="section" title="16.3.4.1. Worker Package Staging">
<div class="titlepage"><div><div><h4 class="title">
<a name="idp43892032"></a>16.3.4.1. Worker Package Staging</h4></div></div></div>
<p>Starting Pegasus 3.0 there is a separate boolean property
        <span class="bold"><strong>pegasus.transfer.worker.package</strong></span> to
        enable worker package staging to the remote compute sites. Earlier it
        was bundled with user executables staging i.e if <span class="bold"><strong>pegasus.catalog.transformation.mapper</strong></span> property
        was set to Staged .</p>
</div>
</div>
<div class="section" title="16.3.5. Clients in bin directory">
<div class="titlepage"><div><div><h3 class="title">
<a name="idp45010848"></a>16.3.5. Clients in bin directory</h3></div></div></div>
<p>Starting with Pegasus 3.0 the pegasus clients in the bin directory
      have a pegasus prefix. The table below lists the old client names and
      new names for the clients that replaced them</p>
<div class="table">
<a name="idp45012224"></a><p class="title"><b>Table 16.6. Table 1: Old Client Names and their New Names</b></p>
<div class="table-contents"><table summary="Table 1: Old Client Names and their New Names" border="1">
<colgroup>
<col>
<col>
</colgroup>
<tbody>
<tr>
<td><span class="bold"><strong>Old Client</strong></span></td>
<td><span class="bold"><strong>New Client</strong></span></td>
</tr>
<tr>
<td>rc-client</td>
<td>pegasus-rc-client</td>
</tr>
<tr>
<td>tc-client</td>
<td>pegasus-tc-client</td>
</tr>
<tr>
<td>pegasus-get-sites</td>
<td>pegasus-sc-client</td>
</tr>
<tr>
<td>sc-client</td>
<td>pegasus-sc-converter</td>
</tr>
<tr>
<td>tailstatd</td>
<td>pegasus-monitord</td>
</tr>
<tr>
<td>genstats and genstats-breakdown</td>
<td>pegasus-statistics</td>
</tr>
<tr>
<td>show-job</td>
<td>pegasus-plots</td>
</tr>
<tr>
<td>cleanup</td>
<td>pegasus-cleanup</td>
</tr>
<tr>
<td>dirmanager</td>
<td>pegasus-dirmanager</td>
</tr>
<tr>
<td>exitcode</td>
<td>pegasus-exitcode</td>
</tr>
<tr>
<td>rank-dax</td>
<td>pegasus-rank-dax</td>
</tr>
<tr>
<td>transfer</td>
<td>pegasus-transfer</td>
</tr>
</tbody>
</table></div>
</div>
<br class="table-break">
</div>
</div>
<div class="navfooter">
<hr>
<table width="100%" summary="Navigation footer">
<tr>
<td width="40%" align="left">
<a accesskey="p" href="migrating_from_3x.php">Prev</a> </td>
<td width="20%" align="center"><a accesskey="u" href="useful_tips.php">Up</a></td>
<td width="40%" align="right"> <a accesskey="n" href="portable_code.php">Next</a>
</td>
</tr>
<tr>
<td width="40%" align="left" valign="top">16.2. Migrating From Pegasus 3.1 to Pegasus 4.X </td>
<td width="20%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="40%" align="right" valign="top"> 16.4. Best Practices For Developing Portable Code</td>
</tr>
</table>
</div>
</div><?php  
            do_html_footer();
        ?>
