<?php  
            include_once( $_SERVER['DOCUMENT_ROOT']."/static/includes/common.inc.php" );
            do_html_header("Documentation");
        ?><div id="content">
<div class="navheader">
<table width="100%" summary="Navigation header"><tr>
<td width="20%" align="left">
<a accesskey="p" href="cli-pegasus-s3.php">Prev</a> </td>
<td width="60%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="20%" align="right"> <a accesskey="n" href="cli-pegasus-sc-converter.php">Next</a>
</td>
</tr></table>
<hr>
</div>
<div lang="en" class="refentry" title="pegasus-sc-client">
<a name="cli-pegasus-sc-client"></a><div class="titlepage"></div>
<div class="refnamediv">
<h2>Name</h2>
<p>pegasus-sc-client — generates a site catalog by querying sources.</p>
</div>
<div class="refsynopsisdiv" title="Synopsis">
<a name="pegasus-sc-client_synopsis"></a><h2>Synopsis</h2>
<div class="blockquote"><blockquote class="blockquote"><div class="literallayout"><p><span class="strong"><strong>pegasus-sc-client</strong></span> [<span class="strong"><strong>-D</strong></span><span class="emphasis"><em>property=value</em></span>…]<br>
                  [<span class="strong"><strong>--source</strong></span> <span class="emphasis"><em>src</em></span>]<br>
                  [<span class="strong"><strong>-g</strong></span>|<span class="strong"><strong>--grid</strong></span> <span class="emphasis"><em>grid</em></span>]<br>
                  [<span class="strong"><strong>-o</strong></span>|<span class="strong"><strong>--vo</strong></span> <span class="emphasis"><em>vo</em></span>]<br>
                  [<span class="strong"><strong>-s</strong></span>|<span class="strong"><strong>--sc</strong></span> <span class="emphasis"><em>scfile</em></span>]<br>
                  [<span class="strong"><strong>-p</strong></span>|<span class="strong"><strong>--properties</strong></span> <span class="emphasis"><em>propfile</em></span>]<br>
                  [<span class="strong"><strong>-V</strong></span>|<span class="strong"><strong>--version</strong></span>]<br>
                  [<span class="strong"><strong>-v</strong></span>|<span class="strong"><strong>--verbose</strong></span>]<br>
                  [<span class="strong"><strong>-h</strong></span>|<span class="strong"><strong>--help</strong></span>]</p></div></blockquote></div>
</div>
<div class="refsect1" title="Description">
<a name="pegasus-sc-client_description"></a><h2>Description</h2>
<p><span class="strong"><strong>pegasus-sc-client</strong></span> generates site catalog by querying sources like OSGMM,
MYSOG, etc.</p>
</div>
<div class="refsect1" title="Options">
<a name="pegasus-sc-client_options"></a><h2>Options</h2>
<div class="variablelist"><dl>
<dt><span class="term">
<span class="strong"><strong>-D</strong></span><span class="emphasis"><em>property=value</em></span>
</span></dt>
<dd>
<p class="simpara">
The <span class="strong"><strong>-D</strong></span> option allows an experienced user to override certain properties
which influence the program execution, among them the default location of
the user’s properties file and the <span class="strong"><strong>PEGASUS_HOME</strong></span> location. One may set several
CLI properties by giving this option multiple times.
</p>
<p class="simpara">The <span class="strong"><strong>-D</strong></span> option(s) must be the first option on the command line. CLI properties
take precedence over the file-based properties of the same key.</p>
</dd>
<dt><span class="term">
<span class="strong"><strong>--source</strong></span> <span class="emphasis"><em>src</em></span>
</span></dt>
<dd>
the source to query for site information. Valid sources are: OSGMM
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-g</strong></span> <span class="emphasis"><em>grid</em></span>
, </span><span class="term">
<span class="strong"><strong>--grid</strong></span> <span class="emphasis"><em>grid</em></span>
</span>
</dt>
<dd>
the grid for which to generate the site catalog information.
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-o</strong></span> <span class="emphasis"><em>vo</em></span>
, </span><span class="term">
<span class="strong"><strong>--vo</strong></span> <span class="emphasis"><em>vo</em></span>
</span>
</dt>
<dd>
<p class="simpara">
The Virtual Organization (VO) to which the user belongs. The default VO is
LIGO. The collector host should be set by default unless overridden by the
property <span class="strong"><strong>pegasus.catalog.site.osgmm.collector.host</strong></span> according to the
following rules:
</p>
<div class="itemizedlist"><ul class="itemizedlist" type="disc">
<li class="listitem">
if VO is ligo then collector host queried is ligo-osgmm.renci.org
</li>
<li class="listitem">
if VO is engage then collector host queried is engage-central.renci.org
</li>
<li class="listitem">
for any other VO, engage-central.renci.org will be queried and in all the
paths the name of the engage VO will be replaced with the name of the VO
passed. e.g if user specifies the VO to be <span class="strong"><strong>cigi</strong></span>, <span class="strong"><strong>engage</strong></span> will be
replaced by <span class="strong"><strong>cigi</strong></span> in the directory paths.
</li>
</ul></div>
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-s</strong></span> <span class="emphasis"><em>scfile</em></span>
, </span><span class="term">
<span class="strong"><strong>--sc</strong></span> <span class="emphasis"><em>scfile</em></span>
</span>
</dt>
<dd>
The path to the created site catalog file
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-p</strong></span> <span class="emphasis"><em>propfile</em></span>
, </span><span class="term">
<span class="strong"><strong>--properties</strong></span> <span class="emphasis"><em>propfile</em></span>
</span>
</dt>
<dd>
Generate a Pegasus properties file containing the SRM properties. The
properties file is created only if <span class="strong"><strong>--source</strong></span> is set to <span class="emphasis"><em>OSGMM</em></span>.
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-v</strong></span>
, </span><span class="term">
<span class="strong"><strong>--verbose</strong></span>
</span>
</dt>
<dd>
Increases the verbosity of messages about what is going on.
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-V</strong></span>
, </span><span class="term">
<span class="strong"><strong>--version</strong></span>
</span>
</dt>
<dd>
Displays the current version of Pegasus.
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-h</strong></span>
, </span><span class="term">
<span class="strong"><strong>--help</strong></span>
</span>
</dt>
<dd>
Displays all the options to the <span class="strong"><strong>pegasus-sc-client</strong></span> command.
</dd>
</dl></div>
</div>
<div class="refsect1" title="Example">
<a name="pegasus-sc-client_example"></a><h2>Example</h2>
<p>Runs <span class="strong"><strong>pegasus-sc-client</strong></span> and generates the site catalog:</p>
<pre class="screen">$ pegasus-sc-client --source OSGMM --sc osg-sites.xml --vo LIGO --grid OSG</pre>
</div>
<div class="refsect1" title="Authors">
<a name="pegasus-sc-client_authors"></a><h2>Authors</h2>
<p>Prasanth Thomas</p>
<p>Pegasus Team <a class="ulink" href="http://pegasus.isi.edu" target="_top">http://pegasus.isi.edu</a></p>
</div>
</div>
<div class="navfooter">
<hr>
<table width="100%" summary="Navigation footer">
<tr>
<td width="40%" align="left">
<a accesskey="p" href="cli-pegasus-s3.php">Prev</a> </td>
<td width="20%" align="center"><a accesskey="u" href="reference.php#cli">Up</a></td>
<td width="40%" align="right"> <a accesskey="n" href="cli-pegasus-sc-converter.php">Next</a>
</td>
</tr>
<tr>
<td width="40%" align="left" valign="top">pegasus-s3 </td>
<td width="20%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="40%" align="right" valign="top"> pegasus-sc-converter</td>
</tr>
</table>
</div>
</div><?php  
            do_html_footer();
        ?>
