<?php  
            include_once( $_SERVER['DOCUMENT_ROOT']."/static/includes/common.inc.php" );
            do_html_header("Documentation");
        ?><div id="content">
<div class="navheader">
<table width="100%" summary="Navigation header"><tr>
<td width="20%" align="left">
<a accesskey="p" href="cli-pegasus-invoke.php">Prev</a> </td>
<td width="60%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="20%" align="right"> <a accesskey="n" href="cli-pegasus-kickstart.php">Next</a>
</td>
</tr></table>
<hr>
</div>
<div lang="en" class="refentry" title="pegasus-keg">
<a name="cli-pegasus-keg"></a><div class="titlepage"></div>
<div class="refnamediv">
<h2>Name</h2>
<p>pegasus-keg — kanonical executable for grids</p>
</div>
<div class="refsynopsisdiv" title="Synopsis">
<a name="pegasus-keg_synopsis"></a><h2>Synopsis</h2>
<div class="blockquote"><blockquote class="blockquote"><div class="literallayout"><p><span class="strong"><strong>pegasus-keg</strong></span> [-a appname] [-t interval |-T interval] [-l logname]<br>
            [-P prefix] [-o fn [..]] [-i fn [..]] [-G sz]<br>
            [-C] [-e env [..]] [-p parm [..]]</p></div></blockquote></div>
</div>
<div class="refsect1" title="Description">
<a name="pegasus-keg_description"></a><h2>Description</h2>
<p>The kanonical executable is a stand-in for regular binaries in a DAG -
but not for their arguments. It allows to trace the shape of the
execution of a DAG, and thus is an aid to debugging DAG related issues.</p>
<p>Key feature of <span class="strong"><strong>pegasus-keg</strong></span> is that it can copy any number of input
files, including the <span class="emphasis"><em>generator</em></span> case, to any number of output files,
including the <span class="emphasis"><em>datasink</em></span> case. In addition, it protocols the IPv4 and
hostname of the host it ran upon, the current timestamp, and the run
time from start til the point of logging the information, the current
working directory and some information on the system environment.
<span class="strong"><strong>pegasus-keg</strong></span> will also report all input files, the current output files
and any requested string and environment value.</p>
</div>
<div class="refsect1" title="Arguments">
<a name="pegasus-keg_arguments"></a><h2>Arguments</h2>
<p>The <span class="strong"><strong>-e</strong></span>, <span class="strong"><strong>-i</strong></span>, <span class="strong"><strong>-o</strong></span> and <span class="strong"><strong>-p</strong></span> arguments allow lists with arbitrary
number of arguments. These options may also occur repeatedly on the
command line. The file options may be provided with the special filename
- to indicate <span class="emphasis"><em>stdout</em></span> in append mode for writing, or <span class="emphasis"><em>stdin</em></span> for
reading. The <span class="strong"><strong>-a</strong></span>, <span class="strong"><strong>-l</strong></span> , <span class="strong"><strong>-P</strong></span> , <span class="strong"><strong>-T</strong></span> and <span class="strong"><strong>-t</strong></span> arguments should only
occur a single time with a single argument.</p>
<p>If <span class="strong"><strong>pegasus-keg</strong></span>
is called without any arguments, it will display its usage and exit with
success.</p>
<div class="variablelist"><dl>
<dt><span class="term">
<span class="strong"><strong>-a appname</strong></span>
</span></dt>
<dd>
This option allows <span class="strong"><strong>pegasus-keg</strong></span> to display a different name as its
applications. This mode of operation is useful in make-believe mode. The
default is the basename of <span class="emphasis"><em>argv[0]</em></span>.
</dd>
<dt><span class="term">
<span class="strong"><strong>-e env [..]</strong></span>
</span></dt>
<dd>
This option names any number of environment variables, whose value
should be reported as part of the data dump. By default, no environment
variables are reported.
</dd>
<dt><span class="term">
<span class="strong"><strong>-i infile [..]</strong></span>
</span></dt>
<dd>
The <span class="strong"><strong>pegasus-keg</strong></span> binary can work on any number of input files. For each
output file, every input file will be opened, and its content copied to
the output file. Textual input files are assumed. Each input line is
indented by two spaces. The input file content is bracketed between an
start and end section, see below. By default, <span class="strong"><strong>pegasus-keg</strong></span> operates in
<span class="emphasis"><em>generator</em></span> mode.
</dd>
<dt><span class="term">
<span class="strong"><strong>-l logfile</strong></span>
</span></dt>
<dd>
The <span class="emphasis"><em>logfile</em></span> is the name of a file to append atomically the self-info,
see below. The atomic write guarantees that the multi-line information
will not interleave with other processes that simultaneously write to
the same file. The default is not to use any log file.
</dd>
<dt><span class="term">
<span class="strong"><strong>-o outfile [..]</strong></span>
</span></dt>
<dd>
The <span class="strong"><strong>pegasus-keg</strong></span> can work on any number of output files. For each
output file, every input file will be opened, and its content copied
to the output file. Textual input files are assumed. Each input line
is indented by two spaces. The input file content is bracketed between
an start and end section, see 2nd example. After all input files are
copied, the data dump from this instance of <span class="strong"><strong>pegasus-keg</strong></span> is appended to
the output file. Without output files, <span class="strong"><strong>pegasus-keg</strong></span> operates in <span class="emphasis"><em>data
sink</em></span> mode.
</dd>
<dt><span class="term">
<span class="strong"><strong>-G size</strong></span>
</span></dt>
<dd>
If you want <span class="strong"><strong>pegasus-keg</strong></span> to generate a lot of output, the generator
option will do that for you. Just specify how much, in bytes, you want.
This option is off by default.
</dd>
<dt><span class="term">
<span class="strong"><strong>-C</strong></span>
</span></dt>
<dd>
This option causes <span class="strong"><strong>pegasus-keg</strong></span> to list all environment variables that
start with the prefix <span class="emphasis"><em>\_CONDOR</em></span> The option is useful, if .B pegasus-keg
is run as (part of) a Condor job. This option is off by default.
</dd>
<dt><span class="term">
<span class="strong"><strong>-p string [..]</strong></span>
</span></dt>
<dd>
Any number of parameters can be reported, without being specific
on their content. Effectively, these strings are copied straight from
the command line. By default, no extra arguments are shown.
</dd>
<dt><span class="term">
<span class="strong"><strong>-P prefix</strong></span>
</span></dt>
<dd>
Each line from every input file is indented with a prefix string to
visually emphasize the provenance of an input files through multiple
instances of <span class="strong"><strong>pegasus-keg</strong></span>. By default, two spaces are used as prefix
string.
</dd>
<dt><span class="term">
<span class="strong"><strong>-t interval</strong></span>
</span></dt>
<dd>
The interval is an amount of sleep time that the <span class="strong"><strong>pegasus-keg</strong></span>
executable is to sleep. This can be used to emulate light work without
straining the pool resources. If used together with the <span class="strong"><strong>-T</strong></span> spin
option, the sleep interval comes before the spin interval. The default
is no sleep time.
</dd>
<dt><span class="term">
<span class="strong"><strong>-T interval</strong></span>
</span></dt>
<dd>
The interval is an amount of busy spin time that the <span class="strong"><strong>pegasus-keg</strong></span>
executable is to simulate intense computation. The simulation is done
by random julia set calculations. This option can be used to emulate an
intense work to strain pool resources. If used together with the <span class="strong"><strong>-t</strong></span>
sleep option, the sleep interval comes before the spin interval. The
default is no spin time.
</dd>
</dl></div>
</div>
<div class="refsect1" title="Return Value">
<a name="pegasus-keg_return_value"></a><h2>Return Value</h2>
<p>Execution as planned will return 0. The failure to open an input file
will return 1, the failure to open an output file, including the log
file, will return with exit code 2.</p>
</div>
<div class="refsect1" title="Example">
<a name="pegasus-keg_example"></a><h2>Example</h2>
<p>The example shows the bracketing of an input file, and the copy
produced on the output file. For illustration purposes, the output
file is connected to <span class="emphasis"><em>stdout</em></span> :</p>
<pre class="screen">$ date &gt; xx
$ pegasus-keg -i xx -p a b c -o -
--- start xx ----
  Thu May  5 10:55:45 PDT 2011
--- final xx ----
Timestamp Today: 20110505T105552.910-07:00 (1304618152.910;0.000)
Applicationname: pegasus-keg [3661M] @ 128.9.xxx.xxx (xxx.isi.edu)
Current Workdir: /opt/pegasus/default/bin/pegasus-keg
Systemenvironm.: x86_64-Linux 2.6.18-238.9.1.el5
Processor Info.: 4 x Intel(R) Core(TM) i5 CPU         750  @ 2.67GHz @ 2660.068
Load Averages  : 0.298 0.135 0.104
Memory Usage MB: 11970 total, 8089 free, 0 shared, 695 buffered
Swap Usage   MB: 12299 total, 12299 free
Filesystem Info: /                        ext3    62GB total,    20GB avail
Filesystem Info: /lfs/balefire            ext4  1694GB total,  1485GB avail
Filesystem Info: /boot                    ext2   493MB total,   447MB avail
Output Filename: -
Input Filenames: xx
Other Arguments: a b c</pre>
</div>
<div class="refsect1" title="Restrictions">
<a name="pegasus-keg_restrictions"></a><h2>Restrictions</h2>
<p>The input file must be textual files. The behaviour with binary files
is unspecified.</p>
<p>The host address is determined from the primary interface. If there is
no active interface besides loopback, the host address will default
to 0.0.0.0. If the host address is within a <span class="emphasis"><em>virtual private network</em></span>
address range, only <span class="emphasis"><em>(VPN)</em></span> will be displayed as hostname, and no
reverse address lookup will be attempted.</p>
<p>The
<span class="emphasis"><em>processor info</em></span>
line is only available on Linux systems. The line will be missing on
other operating systems. Its information is assuming symmetrical multi
processing, reflecting the CPU name and speed of the last CPU available
in
<span class="emphasis"><em>/dev/cpuinfo</em></span> .</p>
<p>There is a limit of
<span class="emphasis"><em>4 * page size</em></span>
to the output buffer of things that
.B pegasus-keg
can report in its self-info dump. There is no such restriction on the
input to output file copy.</p>
</div>
<div class="refsect1" title="Authors">
<a name="pegasus-keg_authors"></a><h2>Authors</h2>
<p>Jens-S. Vöckler &lt;voeckler at isi dot edu&gt;</p>
<p>Mike Wilde</p>
<p>Yong Zhao</p>
<p>Pegasus - <a class="ulink" href="http://pegasus.isi.edu/" target="_top">http://pegasus.isi.edu/</a></p>
</div>
</div>
<div class="navfooter">
<hr>
<table width="100%" summary="Navigation footer">
<tr>
<td width="40%" align="left">
<a accesskey="p" href="cli-pegasus-invoke.php">Prev</a> </td>
<td width="20%" align="center"><a accesskey="u" href="reference.php#cli">Up</a></td>
<td width="40%" align="right"> <a accesskey="n" href="cli-pegasus-kickstart.php">Next</a>
</td>
</tr>
<tr>
<td width="40%" align="left" valign="top">pegasus-invoke </td>
<td width="20%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="40%" align="right" valign="top"> pegasus-kickstart</td>
</tr>
</table>
</div>
</div><?php  
            do_html_footer();
        ?>
