<?php  
            include_once( $_SERVER['DOCUMENT_ROOT']."/static/includes/common.inc.php" );
            do_html_header("Documentation");
        ?><div id="content">
<div class="navheader">
<table width="100%" summary="Navigation header"><tr>
<td width="20%" align="left">
<a accesskey="p" href="tutorial.php">Prev</a> </td>
<td width="60%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="20%" align="right"> <a accesskey="n" href="creating_workflows.php">Next</a>
</td>
</tr></table>
<hr>
</div>
<div class="chapter" title="Chapter 3. Installation">
<div class="titlepage"><div><div><h2 class="title">
<a name="installation"></a>Chapter 3. Installation</h2></div></div></div>
<div class="toc"><dl>
<dt><span class="section"><a href="installation.php#prereqs">3.1. Prerequisites</a></span></dt>
<dt><span class="section"><a href="installation.php#optional">3.2. Optional Software</a></span></dt>
<dt><span class="section"><a href="installation.php#env">3.3. Environment</a></span></dt>
<dt><span class="section"><a href="installation.php#native_packages">3.4. Native Packages (RPM/DEB)</a></span></dt>
<dt><span class="section"><a href="installation.php#tarballs">3.5. Pegasus from Tarballs</a></span></dt>
</dl></div>
<div class="section" title="3.1. Prerequisites">
<div class="titlepage"><div><div><h2 class="title" style="clear: both">
<a name="prereqs"></a>3.1. Prerequisites</h2></div></div></div>
<p>Pegasus has a few dependencies:</p>
<div class="itemizedlist"><ul class="itemizedlist" type="disc">
<li class="listitem">
<p><span class="bold"><strong>Java 1.6 or higher</strong></span>. Check
        with:</p>
<pre class="programlisting"># <span class="bold"><strong>java -version</strong></span>
java version "1.6.0_07"
Java(TM) 2 Runtime Environment, Standard Edition (build 1.6.0_07-164)
Java HotSpot(TM) Client VM (build 1.6.0_07-87, mixed mode, sharing)</pre>
</li>
<li class="listitem">
<p><span class="bold"><strong>Python 2.4 or higher</strong></span>. Check
        with:</p>
<pre class="programlisting"># <span class="bold"><strong>python -v</strong></span>
Python 2.6.2</pre>
</li>
<li class="listitem"><p><span class="bold"><strong>HTCondor (formerly Condor) 7.8 or higher</strong></span>. See
        <a class="ulink" href="http://www.cs.wisc.edu/htcondor/" target="_top">http://www.cs.wisc.edu/htcondor/</a>
        for more information. You should be able to run
        <code class="filename">condor_q</code> and
        <code class="filename">condor_status</code>.</p></li>
</ul></div>
</div>
<div class="section" title="3.2. Optional Software">
<div class="titlepage"><div><div><h2 class="title" style="clear: both">
<a name="optional"></a>3.2. Optional Software</h2></div></div></div>
<div class="itemizedlist"><ul class="itemizedlist" type="disc"><li class="listitem">
<p><span class="bold"><strong>Globus 4.0 or higher</strong></span>. Globus is
        only needed if you want to run against grid sites or use GridFTP for
        data transfers. See <a class="ulink" href="http://www.globus.org/" target="_top">http://www.globus.org/</a> for more
        information. Check Globus Installation</p>
<pre class="programlisting"># <span class="bold"><strong>echo $GLOBUS_LOCATION</strong></span>
/path/to/globus/install</pre>
<p>Make sure you source the Globus environment</p>
<pre class="programlisting">#<span class="bold"><strong> GLOBUS_LOCATION/etc/globus-user-env.sh</strong></span></pre>
<p>Check the setup by running:#</p>
<pre class="programlisting"><span class="bold"><strong># globus-version</strong></span>
5.2.0</pre>
</li></ul></div>
</div>
<div class="section" title="3.3. Environment">
<div class="titlepage"><div><div><h2 class="title" style="clear: both">
<a name="env"></a>3.3. Environment</h2></div></div></div>
<p>To use Pegasus, you need to have the pegasus-* tools in your PATH.
    If you have installed Pegasus from RPM/DEB packages. the tools will be in
    the default PATH, in /usr/bin. If you have installed Pegasus from binary
    tarballs or source, add the bin/ directory to your PATH.</p>
<pre class="programlisting">  Example for bourne shells:

    # <span class="bold"><strong>export PATH=/some/install/pegasus-4.3.0/bin:$PATH</strong></span></pre>
<div class="note" title="Note" style="margin-left: 0.5in; margin-right: 0.5in;">
<h3 class="title">Note</h3>
<p>Pegasus 4.x is different from previous versions of Pegasus in that
      it does not require PEGASUS_HOME to be set or sourcing of any
      environtment setup scripts.</p>
</div>
<p>If you want to use the <a class="link" href="reference.php#api" title="10.9. API Reference">DAX APIs</a>, you
    might also need to set your PYTHONPATH, PERL5LIB, or CLASSPATH. The right
    setting can be found by using pegasus-config:</p>
<pre class="programlisting"># <span class="bold"><strong>export PYTHONPATH=`pegasus-config --python`</strong></span>
# <span class="bold"><strong>export PERL5LIB=`pegasus-config --perl`</strong></span>
# <span class="bold"><strong>export CLASSPATH=`pegasus-config --classpath`</strong></span></pre>
</div>
<div class="section" title="3.4. Native Packages (RPM/DEB)">
<div class="titlepage"><div><div><h2 class="title" style="clear: both">
<a name="native_packages"></a>3.4. Native Packages (RPM/DEB)</h2></div></div></div>
<div class="toc"><dl>
<dt><span class="section"><a href="installation.php#rhel">3.4.1. RHEL / CentOS / Scientific Linux</a></span></dt>
<dt><span class="section"><a href="installation.php#debian">3.4.2. Debian</a></span></dt>
</dl></div>
<p>The preferred way to install Pegasus is with native (RPM/DEB)
    packages. It is recommended that you also install HTCondor (formerly Condor)
    (<a class="ulink" href="http://research.cs.wisc.edu/htcondor/yum/" target="_top">yum</a>, <a class="ulink" href="http://research.cs.wisc.edu/htcondor/debian/" target="_top">debian</a>) from
    native packages.</p>
<div class="section" title="3.4.1. RHEL / CentOS / Scientific Linux">
<div class="titlepage"><div><div><h3 class="title">
<a name="rhel"></a>3.4.1. RHEL / CentOS / Scientific Linux</h3></div></div></div>
<p>Add the Pegasus repository to yum downloading the Pegasus repos
      file and adding it to<span class="bold"><strong>
      <code class="filename">/etc/yum.repos.d/</code></strong></span>. For RHEL 5 based
      systemes:</p>
<pre class="programlisting"># <span class="bold"><strong>wget -O /etc/yum.repos.d/pegasus.repo http://download.pegasus.isi.edu/wms/download/rhel/5/pegasus.repo</strong></span></pre>
<p>For RHEL 6 based systems:</p>
<pre class="programlisting"># <span class="bold"><strong>wget -O /etc/yum.repos.d/pegasus.repo http://download.pegasus.isi.edu/wms/download/rhel/6/pegasus.repo</strong></span></pre>
<p>Search for, and install Pegasus:</p>
<pre class="programlisting"># <span class="bold"><strong>yum search pegasus</strong></span>
pegasus.x86_64 : Workflow management system for Condor, grids, and clouds
# <span class="bold"><strong>yum install pegasus</strong></span>
Running Transaction
Installing     : pegasus

Installed:
pegasus   :4.3.0-1                                                                                                                        

Complete!</pre>
</div>
<div class="section" title="3.4.2. Debian">
<div class="titlepage"><div><div><h3 class="title">
<a name="debian"></a>3.4.2. Debian</h3></div></div></div>
<p>To be able to install and upgrade from the Pegasus apt repository,
      you will have to trust the repository key. You only need to add the
      repository key once:</p>
<pre class="programlisting"># <span class="bold"><strong>gpg --keyserver pgp.mit.edu --recv-keys 81C2A4AC</strong></span>
# <span class="bold"><strong>gpg -a --export 81C2A4AC | apt-key add -</strong></span>  </pre>
<p>Add the Pegasus apt repository to your
      <code class="filename">/etc/apt/sources.list</code> file:</p>
<pre class="programlisting">deb http://download.pegasus.isi.edu/wms/download/debian wheezy main</pre>
<p>Install Pegasus with <span class="bold"><strong>apt-get
      :</strong></span></p>
<pre class="programlisting"># <span class="bold"><strong>apt-get update</strong></span>
...
# <span class="bold"><strong>apt-get install pegasus</strong></span></pre>
</div>
</div>
<div class="section" title="3.5. Pegasus from Tarballs">
<div class="titlepage"><div><div><h2 class="title" style="clear: both">
<a name="tarballs"></a>3.5. Pegasus from Tarballs</h2></div></div></div>
<p>The Pegasus prebuild tarballs can be downloaded from the <a class="ulink" href="http://pegasus.isi.edu/downloads" target="_top"><span class="emphasis"><em>Pegasus
    Download Page</em></span></a>.</p>
<p>Use these tarballs if you already have HTCondor installed or prefer to
    keep the HTCondor installation separate from the Pegasus
    installation.</p>
<div class="itemizedlist"><ul class="itemizedlist" type="disc">
<li class="listitem">
<p>Untar the tarball</p>
<pre class="programlisting"># <span class="bold"><strong>tar zxf pegasus-*.tar.gz</strong></span></pre>
</li>
<li class="listitem">
<p>include the Pegasus bin directory in your PATH</p>
<pre class="programlisting"># <span class="bold"><strong>export PATH=/path/to/pegasus-4.3.0:$PATH</strong></span></pre>
</li>
</ul></div>
</div>
</div>
<div class="navfooter">
<hr>
<table width="100%" summary="Navigation footer">
<tr>
<td width="40%" align="left">
<a accesskey="p" href="tutorial.php">Prev</a> </td>
<td width="20%" align="center"> </td>
<td width="40%" align="right"> <a accesskey="n" href="creating_workflows.php">Next</a>
</td>
</tr>
<tr>
<td width="40%" align="left" valign="top">Chapter 2. Tutorial </td>
<td width="20%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="40%" align="right" valign="top"> Chapter 4. Creating Workflows</td>
</tr>
</table>
</div>
</div><?php  
            do_html_footer();
        ?>
