#!/bin/sh
#
# @package      hubzero-submit-monitors
# @file         refresh-oauth-token.sh
# @copyright    Copyright (c) 2015-2021 The Regents of the University of California.
# @license      http://opensource.org/licenses/MIT MIT
#
# Copyright (c) 2015-2021 The Regents of the University of California.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# HUBzero is a registered trademark of The Regents of the University of California.
#
scriptPath=$(readlink -f $0)
scriptDir=$(dirname ${scriptPath})

if [ $# -ne 1 ] ; then
   echo "usage: $0 oauthName"
   exit 64
fi

exitStatus=0

oauthName=$1

if [ ${oauthName} = tapis ] ; then
   python3 /var/gridman/submit/bin/Tapis/refreshToken.py
   exitStatus=$?
   if [ ${exitStatus} -ne 0 ] ; then
      python3 /var/gridman/submit/bin/Tapis/resetToken.py
      exitStatus=$?
   fi
fi

exit ${exitStatus}
