#!/bin/sh
#
# @package      hubzero-submit-monitors
# @file         generate-grid-proxy.sh
# @author       Steven Clark <clarks@purdue.edu>
# @copyright    Copyright (c) 2015-2015 HUBzero Foundation, LLC.
# @license      http://opensource.org/licenses/MIT MIT
#
# Copyright (c) 2015-2015 HUBzero Foundation, LLC.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# HUBzero is a registered trademark of HUBzero Foundation, LLC.
#
if [ $# -lt 4 ] ; then
   echo usage: $0 certKeyDirectory certFile keyFile proxyFile
   exit 64
fi

exitStatus=0

certKeyDirectory=$1
certFile=$2
keyFile=$3
proxyFile=$4

if [ ! -d ${certKeyDirectory} ] ; then
   echo "${certKeyDirectory} is not a directory"
   exitStatus=1
else
   if [ ! -f ${certKeyDirectory}/${certFile} ] ; then
      echo "${certFile} does not exist"
      exitStatus=1
   fi
   if [ ! -f ${certKeyDirectory}/${keyFile} ] ; then
      echo "${keyFile} does not exist"
      exitStatus=1
   fi
fi

if [ ${exitStatus} -eq 0 ] ; then
   grid-proxy-init -q \
                   -cert ${certKeyDirectory}/${certFile} \
                   -key ${certKeyDirectory}/${keyFile} \
                   -valid 12:0 \
                   -out ${certKeyDirectory}/${proxyFile}
   exitStatus=$?
   if [ ${exitStatus} -eq 0 ] ; then
      /bin/chmod 0600 ${certKeyDirectory}/${proxyFile}
   fi
fi

exit ${exitStatus}
