#!/usr/bin/env python
#
# @package      hubzero-submit-monitors
# @file         monitorJobU.py
# @author       Steven Clark <clarks@purdue.edu>
# @copyright    Copyright (c) 2004-2014 HUBzero Foundation, LLC.
# @license      http://www.gnu.org/licenses/lgpl-3.0.html LGPLv3
#
# Copyright (c) 2004-2014 HUBzero Foundation, LLC.
#
# This file is part of: The HUBzero(R) Platform for Scientific Collaboration
#
# The HUBzero(R) Platform for Scientific Collaboration (HUBzero) is free
# software: you can redistribute it and/or modify it under the terms of
# the GNU Lesser General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any
# later version.
#
# HUBzero is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# HUBzero is a registered trademark of HUBzero Foundation, LLC.
#
# ----------------------------------------------------------------------
#  monitorJobU.py
#
#  script which queries monitorJob.py for active job(s) belonging to a user
#
import os
import time
import logging

from hubzero.submit.RemoteJobMonitor import RemoteJobMonitor

JOBMONITORHOST = ""
JOBMONITORPORT = 5727

APPLICATIONLOGGER = logging.getLogger('') 

def openLogger():
   class EmptyFilter(logging.Filter):
      """
      This is a filter which rejects empty messages

      """

      def filter(self,record):
         if record.getMessage() == "":
            emptyRecord = True
         else:
            emptyRecord = False

         return(not emptyRecord)

   APPLICATIONLOGGER.setLevel(logging.DEBUG)

   logHandler = logging.StreamHandler()

   emptyFilter = EmptyFilter()
   logHandler.addFilter(emptyFilter)

   logFormatter = logging.Formatter('%(asctime)s %(message)s','[%a %b %d %H:%M:%S %Y]')
   logHandler.setFormatter(logFormatter)
   APPLICATIONLOGGER.addHandler(logHandler)


def monitorJobU():
   """Report user jobs"""
   hubUserId = os.getuid()

   remoteJobMonitor = RemoteJobMonitor(JOBMONITORHOST,JOBMONITORPORT)

   reportTime,reportedJobs = remoteJobMonitor.queryUserActiveJobStatus(hubUserId)
   if len(reportedJobs) > 0:
      print "Report time %s" % (time.ctime(reportTime))

      maximumRunNameLength = 0
      localJobIds = reportedJobs.keys()
      for localJobId in localJobIds:
         instanceIds = reportedJobs[localJobId].keys()
         for instanceId in instanceIds:
            runName,jobQueue,jobSite,jobStatus,jobStage = reportedJobs[localJobId][instanceId]
            maximumRunNameLength = max(maximumRunNameLength,len(runName))

      localJobIds = reportedJobs.keys()
      localJobIds.sort()
      for localJobId in localJobIds:
         instanceIds = reportedJobs[localJobId].keys()
         instanceIds.sort()
         for instanceId in instanceIds:
            runName,jobQueue,jobSite,jobStatus,jobStage = reportedJobs[localJobId][instanceId]
            if jobQueue != '?':
               queueSite = jobQueue + '@' + jobSite
            else:
               queueSite = jobSite
            print "%-*s  %12s  %8s  %20s  %15s  %s" % (maximumRunNameLength,runName, \
                                                       localJobId,instanceId,jobStatus,jobStage,queueSite)
   else:
      print "Current time %s" % (time.ctime())
      print "No jobs currently being processed"

   del reportedJobs


if __name__ == '__main__':
   openLogger()
   monitorJobU()


