#!/usr/bin/env python
#
# @package      hubzero-submit-monitors
# @file         monitorTunnelT.py
# @author       Steven Clark <clarks@purdue.edu>
# @copyright    Copyright (c) 2004-2014 HUBzero Foundation, LLC.
# @license      http://www.gnu.org/licenses/lgpl-3.0.html LGPLv3
#
# Copyright (c) 2004-2014 HUBzero Foundation, LLC.
#
# This file is part of: The HUBzero(R) Platform for Scientific Collaboration
#
# The HUBzero(R) Platform for Scientific Collaboration (HUBzero) is free
# software: you can redistribute it and/or modify it under the terms of
# the GNU Lesser General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any
# later version.
#
# HUBzero is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# HUBzero is a registered trademark of HUBzero Foundation, LLC.
#
# ----------------------------------------------------------------------
#  monitorTunnelT.py
#
#  script which terminates an ssh tunnel
#
import sys
import logging

from hubzero.submit.RemoteTunnelMonitor import RemoteTunnelMonitor

TUNNELMONITORHOST = ""
TUNNELMONITORPORT = 5729

APPLICATIONLOGGER = logging.getLogger('') 

def openLogger():
   class EmptyFilter(logging.Filter):
      """
      This is a filter which rejects empty messages

      """

      def filter(self,record):
         if record.getMessage() == "":
            emptyRecord = True
         else:
            emptyRecord = False

         return(not emptyRecord)

   APPLICATIONLOGGER.setLevel(logging.DEBUG)

   logHandler = logging.StreamHandler()

   emptyFilter = EmptyFilter()
   logHandler.addFilter(emptyFilter)

   logFormatter = logging.Formatter('%(asctime)s %(message)s','[%a %b %d %H:%M:%S %Y]')
   logHandler.setFormatter(logFormatter)
   APPLICATIONLOGGER.addHandler(logHandler)


def monitorTunnelT():
   """Terminate ssh tunnel"""
   tunnelName = sys.argv[1]

   remoteTunnelMonitor = RemoteTunnelMonitor(TUNNELMONITORHOST,TUNNELMONITORPORT)

   useCount = remoteTunnelMonitor.terminateTunnelUse(tunnelName)
   print("%s %s" % (tunnelName,useCount))


if __name__ == '__main__':
   openLogger()
   monitorTunnelT()


