# @package      hubzero-submit-monitors
# @file         JobInfo.py
# @author       Steven Clark <clarks@purdue.edu>
# @copyright    Copyright (c) 2012-2014 HUBzero Foundation, LLC.
# @license      http://www.gnu.org/licenses/lgpl-3.0.html LGPLv3
#
# Copyright (c) 2012-2014 HUBzero Foundation, LLC.
#
# This file is part of: The HUBzero(R) Platform for Scientific Collaboration
#
# The HUBzero(R) Platform for Scientific Collaboration (HUBzero) is free
# software: you can redistribute it and/or modify it under the terms of
# the GNU Lesser General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any
# later version.
#
# HUBzero is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# HUBzero is a registered trademark of HUBzero Foundation, LLC.
#

import time
import logging
from UserDict import UserDict

class JobInfo(UserDict):
   def __init__(self,
                messageSite,
                remoteJobId,
                distributorPid=0,
                runName="",
                nCores=1,
                localJobId=0,
                instanceId=0,
                jobStatus='?',
                jobStage='?',
                jobQueue='?',
                hubUserId='?',
                destination='?',
                timeRecorded=0.):
      self.logger  = logging.getLogger(__name__)

      UserDict.__init__(self)

      self['messageSite']     = messageSite
      self['remoteJobId']     = remoteJobId
      self['distributorPid']  = distributorPid
      self['runName']         = runName
      self['nCores']          = nCores
      self['localJobId']      = localJobId
      self['instanceId']      = instanceId
      self['jobStatus']       = jobStatus
      self['jobStage']        = jobStage
      self['jobQueue']        = jobQueue
      self['hubUserId']       = hubUserId
      self['destination']     = destination
      if timeRecorded > 0.:
         self['timeRecorded'] = timeRecorded
      else:
         self['timeRecorded'] = time.time()


   def __missing__(self,
                   key):
      self[key] = '?'

      return('?')


