#!/bin/sh
#
# @package      hubzero-submit-distributor
# @file         Scripts/boinc/cleanupjob.sh
# @copyright    Copyright 2017-2018 The Regents of the University of California.
# @license      http://www.gnu.org/licenses/lgpl-3.0.html LGPLv3
#
# Copyright (c) 2017-2018 The Regents of the University of California
# All rights reserved.
#
# This file is part of: The HUBzero(R) Platform for Scientific Collaboration
#
# The HUBzero(R) Platform for Scientific Collaboration (HUBzero) is free
# software: you can redistribute it and/or modify it under the terms of
# the GNU Lesser General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any
# later version.
#
# HUBzero is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# HUBzero is a registered trademark of The Regents of the University of California.
#
if [ $# -ne 3 ] ; then
   echo usage: $0 jobWorkingDirectory jobScratchDirectory jobClass
   exit 64
fi

jobWorkingDirectory=$1
jobScratchDirectory=$2
jobClass=$3

binDirectory=$(readlink -f $(dirname $0))

cd ${jobWorkingDirectory}
exitStatus=$?

if [ ${exitStatus} -eq 0 ] ; then
   BATCHID=0
   remoteJobIdFile=$(ls .__remote_jobid.[0-9]*_[0-9]* 2> /dev/null)
   if [ -n "${remoteJobIdFile}" ] ; then
      jobIdInstance=${remoteJobIdFile##*.}
      localJobId=${jobIdInstance%_*}
      instanceId=${jobIdInstance##*_}
      BATCHID=$(cat ${remoteJobIdFile})
      if [ ${instanceId} -ne 0 ] ; then
         rm -f ${remoteJobIdFile}
      fi
   else
      remoteJobIdFile=$(ls ../.__remote_jobid.[0-9]*_[0-9]* 2> /dev/null)
      if [ -n "${remoteJobIdFile}" ] ; then
         remoteJobIdFile=$(basename ${remoteJobIdFile})
         jobIdInstance=${remoteJobIdFile##*.}
         localJobId=${jobIdInstance%_*}
         instanceId=${jobIdInstance##*_}
         if [ ${instanceId} -ne 0 ] ; then
            exitStatus=1
         fi
      fi
   fi
   if [ ${exitStatus} -eq 0 ] ; then
      if [ ${BATCHID} -gt 0 ] ; then
         ${binDirectory}/retireBatch.py ${BATCHID}
         exitStatus=$?
      fi
   fi
fi

exit ${exitStatus}
