#!/usr/bin/env python
#
# @package      hubzero-submit-monitors
# @file         Scripts/boinc/createBatch.py
# @copyright    Copyright (c) 2017-2020 The Regents of the University of California.
# @license      http://opensource.org/licenses/MIT MIT
#
# Copyright (c) 2017-2020 The Regents of the University of California.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# HUBzero is a registered trademark of The Regents of the University of California.
#
# ----------------------------------------------------------------------
#  creatBatch.py
#
#  script which monitors the BOINC queue and reports changes in job status
#
import sys
import os

from submit_api import *

BOINCPROJECTURL    = ""
BOINCAUTHENTICATOR = ""


class CreateBoincBatch:
   def __init__(self,
                boincProjectURL,
                boincAuthenticator,
                localJobId,
                instanceId):
      self.boincProjectURL    = boincProjectURL
      self.boincAuthenticator = boincAuthenticator
      self.localJobId         = localJobId
      self.instanceId         = instanceId
      self.batchId            = 0


   def run(self):
      exitStatus = 0
      batchRequest = CREATE_BATCH_REQ()
      batchRequest.project       = self.boincProjectURL
      batchRequest.authenticator = self.boincAuthenticator
      batchRequest.app_name      = "boinc2docker"
      batchRequest.batch_name    = '_'.join([self.localJobId,self.instanceId])
      batchRequest.get_cpu_time  = False
      batchRequest.expire_time   = 0

      createBatchResponse = create_batch(batchRequest)

      if createBatchResponse.find('error') is not None:
         exitStatus = 1
         errMessage = createBatchResponse.find('error').find('error_msg').text
         sys.stderr.write(errMessage + '\n')
      else:
         self.batchId = int(createBatchResponse[0].text)

         remoteJobIdFileName = ".__remote_jobid.%s_%s" % (self.localJobId,self.instanceId)
         try:
            fpRemoteJobId = open(remoteJobIdFileName,'w')
            try:
               fpRemoteJobId.write("%s\n" % (self.batchId))
            except (IOError,OSError):
               sys.stderr.write("could not write %s\n" % (remoteJobIdFileName))
               exitStatus = 1
            finally:
               fpRemoteJobId.close()
         except (IOError,OSError):
            sys.stderr.write("could not open %s\n" % (remoteJobIdFileName))
            exitStatus = 1

      return(exitStatus)


if __name__ == '__main__':

   if len(sys.argv) == 3:
      localJobId = sys.argv[1]
      instanceId = sys.argv[2]
   else:
      sys.exit(1)

   __createBoincBatch__ = CreateBoincBatch(BOINCPROJECTURL,BOINCAUTHENTICATOR,
                                           localJobId,instanceId)
   __exitStatus__ = __createBoincBatch__.run()

   sys.exit(__exitStatus__)


