# @package      hubzero-submit-distributor
# @file         RemoteTunnelMonitor.py
# @author       Steven Clark <clarks@purdue.edu>
# @copyright    Copyright (c) 2012-2015 HUBzero Foundation, LLC.
# @license      http://opensource.org/licenses/MIT MIT
#
# Copyright (c) 2012-2015 HUBzero Foundation, LLC.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# HUBzero is a registered trademark of HUBzero Foundation, LLC.
#
import time
import traceback
import logging

from hubzero.submit.LogMessage        import getLogIDMessage as getLogMessage
from hubzero.submit.MessageConnection import MessageConnection

class RemoteTunnelMonitor(MessageConnection):
   def __init__(self,
                listenURI):
      MessageConnection.__init__(self,listenURI)

      self.logger = logging.getLogger(__name__)


   def getTunnelAddressPort(self,
                            tunnelName):
      address = ""
      port    = ""

      queryMessage = {'messageType':'getTunnelAddress',
                      'tunnelDesignator':tunnelName}
      nTry,response = self.requestJsonExchange(queryMessage)

      if nTry > 1:
         self.logger.log(logging.WARNING,getLogMessage("confirmation: getTunnelAddress(%d):%s" % (nTry,response['messageType'])))

      address = response['address']
      port    = response['port']

      return(address,port)


   def incrementTunnelUse(self,
                          tunnelName):
      useCount = 0

      queryMessage = {'messageType':'incrementTunnelUsage',
                      'tunnelDesignator':tunnelName}
      nTry,response = self.requestJsonExchange(queryMessage)

      if nTry > 1:
         self.logger.log(logging.WARNING,getLogMessage("confirmation: incrementTunnelUsage(%d):%s" % \
                                                                  (nTry,response['messageType'])))

      useCount = response['useCount']

      return(useCount)


   def decrementTunnelUse(self,
                          tunnelName):
      useCount = 0

      queryMessage = {'messageType':'decrementTunnelUsage',
                      'tunnelDesignator':tunnelName}
      nTry,response = self.requestJsonExchange(queryMessage)

      if nTry > 1:
         self.logger.log(logging.WARNING,getLogMessage("confirmation: decrementTunnelUsage(%d):%s" % \
                                                                  (nTry,response['messageType'])))

      useCount = response['useCount']

      return(useCount)


   def terminateTunnelUse(self,
                          tunnelName):
      useCount = 0

      queryMessage = {'messageType':'terminateTunnel',
                      'tunnelDesignator':tunnelName}
      nTry,response = self.requestJsonExchange(queryMessage)

      if nTry > 1:
         self.logger.log(logging.WARNING,getLogMessage("confirmation: terminateTunnel(%d):%s" % \
                                                                  (nTry,response['messageType'])))

      useCount = response['useCount']

      return(useCount)


   def reportTunnelUse(self,
                       tunnelName=""):
      response = ""

      queryMessage = {'messageType':'reportActiveTunnels',
                      'tunnelDesignator':tunnelName}
      nTry,response = self.requestJsonExchange(queryMessage)

      if nTry > 1:
         self.logger.log(logging.WARNING,getLogMessage("confirmation: reportActiveTunnels(%d):%s" % \
                                                                  (nTry,response['messageType'])))

      return(response)


