#!/bin/sh
#
# @package      hubzero-submit-distributor
# @file         Scripts/boinc/receiveinput.sh
# @author       Steve Clark <clarks@purdue.edu>
# @copyright    Copyright 2017-2018 Purdue University. All rights reserved.
# @license      http://www.gnu.org/licenses/lgpl-3.0.html LGPLv3
#
# Copyright (c) 2017-2018 Purdue University
# All rights reserved.
#
# This file is part of: The HUBzero(R) Platform for Scientific Collaboration
#
# The HUBzero(R) Platform for Scientific Collaboration (HUBzero) is free
# software: you can redistribute it and/or modify it under the terms of
# the GNU Lesser General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any
# later version.
#
# HUBzero is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# HUBzero is a registered trademark of Purdue University.
#
if [ $# -ne 3 ] ; then
   echo usage: $0 jobWorkingDirectory jobScratchDirectory transferredTimestampFile
   exit 64
fi

jobWorkingDirectory=$1
jobScratchDirectory=$2
transferredTimestampFile=$3

binDirectory=$(dirname $0)

sharedFileSystem=1

if [ ${sharedFileSystem} -eq 1 ] ; then
   cd ${jobWorkingDirectory}
   exitStatus=$?

   if [ ${exitStatus} -eq 0 ] ; then
      date +"%s" > ${transferredTimestampFile}
      exitStatus=$?

      if [ ${exitStatus} -eq 0 ] ; then
         localJobIdinstanceId=${transferredTimestampFile##*.}
         localJobId=${localJobIdinstanceId%%_*}
         instanceId=${localJobIdinstanceId#*_}
         runName=$(basename ${jobWorkingDirectory})

         ${binDirectory}/createBatch.py ${localJobId} ${instanceId}
         exitStatus=$?

         if [ ${exitStatus} -eq 0 ] ; then
            BATCHID=$(cat .__remote_jobid.${localJobId}_${instanceId})
            if [ ${instanceId} -eq 0 ] ; then
               ${binDirectory}/uploadFiles.py ${runName} ${localJobId} ${BATCHID}
            else
               ${binDirectory}/uploadFile.py ${localJobId} ${instanceId} ${BATCHID}
            fi
            exitStatus=$?
         fi

         if [ ${exitStatus} -eq 0 ] ; then
            mkdir -p ${jobScratchDirectory}
            exitStatus=$?
         else
            if [ -n "${BATCHID}" ] ; then
               if [ ${BATCHID} -gt 0 ] ; then
                  ${binDirectory}/retireBatch.py ${BATCHID}
               fi
            fi
         fi
      fi
   fi
else
   rm -rf ${jobWorkingDirectory}
   mkdir ${jobWorkingDirectory}
   exitStatus=$?
   
   if [ ${exitStatus} -eq 0 ] ; then
      cd ${jobWorkingDirectory}
      exitStatus=$?
   
      if [ $exitStatus -eq 0 ] ; then
         tar xvzf -
         exitStatus=$?
   
         if [ ${exitStatus} -eq 0 ] ; then
            touch .__fileTimeMarker
            sleep 1
            date +"%s" > ${transferredTimestampFile}
         fi
      fi
   
      mkdir -p ${jobScratchDirectory}
      exitStatus=$?
   fi
fi

exit ${exitStatus}
