#
# @package      hubzero-submit-distributor
# @file         Scripts/tapis2/downloadJobMetricsFiles.py
# @copyright    Copyright 2004-2022 The Regents of the University of California.
# @license      http://opensource.org/licenses/MIT MIT
#
# Copyright (c) 2004-2022 The Regents of the University of California.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# HUBzero is a registered trademark of The Regents of the University of California.
#
import sys
import os
import time

from TapisAPI import TapisAPI

MAXDOWNLOADFAILURES = 3

def downloadFile(uri,
                 localPath,
                 reTry=False):
   success = False
   nFail = 0
   while not success and nFail < MAXDOWNLOADFAILURES:
      try:
         response = tapisAPI.download_uri(uri=uri,local_path=localPath)
         success = True
      except:
         if reTry:
            nFail += 1
            time.sleep(30)
         else:
            break

   return success


exitStatus = 0

tapisAPI = TapisAPI()

jobId              = sys.argv[1]
jobOutputDirectory = sys.argv[2]

jobOutputs = tapisAPI.getJobOutputFilesList(jobId)
#print(jobOutputs)
if jobOutputs:
   if not os.path.isdir(jobOutputDirectory):
      os.makedirs(jobOutputDirectory)

   for jobOutput in jobOutputs:
      outputType = jobOutput['type']
      outputPath = jobOutput['path'].lstrip('/')
      outputURI  = jobOutput['_links']['self']['href']
      if outputType == 'file':
         if outputPath.startswith('.__time_') or \
            outputPath.startswith('.__timestamp_'):
            success = downloadFile(outputURI,os.path.join(jobOutputDirectory,outputPath))
            if not success:
               exitStatus = 1
               sys.stderr.write("Download of %s failed.\n" % (outputPath))

sys.exit(exitStatus)
