#!/bin/sh
#
# @package      hubzero-submit-distributor
# @file         Scripts/tapis3/cleanupjob.sh
# @copyright    Copyright 2024-2025 The Regents of the University of California.
# @license      http://opensource.org/licenses/MIT MIT
#
# Copyright (c) 2024-2025 The Regents of the University of California.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# HUBzero is a registered trademark of The Regents of the University of California.
#
if [ $# -ne 3 ] ; then
   echo usage: $0 jobWorkingDirectory jobScratchDirectory jobClass
   exit 64
fi

jobWorkingDirectory=$1
jobScratchDirectory=$2
jobClass=$3

binDirectory=$(dirname $(readlink -f $0))

cd ${jobWorkingDirectory}
exitStatus=$?

if [ ${exitStatus} -eq 0 ] ; then
   JOBID=0
   remoteJobIdFile=$(ls .__remote_jobid.[0-9]*_[0-9]* 2> /dev/null)
   if [ -n "${remoteJobIdFile}" ] ; then
      jobIdInstance=${remoteJobIdFile##*.}
      localJobId=${jobIdInstance%_*}
      instanceId=${jobIdInstance##*_}
      JOBID=$(cat ${remoteJobIdFile})
      if [ ${instanceId} -ne 0 ] ; then
         inputTarFile=${localJobId}_${instanceId}_input.tar.gz
         tapisDefinitionFile=${localJobId}_${instanceId}.tapis3
         if [ -f ${tapisDefinitionFile} ] ; then
            systemId=$(grep tapislocal ${tapisDefinitionFile} | sed -e "s:/*JobInputs.*::" | sed -e "s:.*/::")
            instanceToken=$(grep tapislocal ${tapisDefinitionFile} | sed -e "s:.*/JobInputs/::" | sed -e "s:/.*::")
            python3.11 ${binDirectory}/removeJobInputs.py ${systemId} ${instanceToken}
         fi
         rm -f ${remoteJobIdFile}
      fi
   else
      remoteJobIdFile=$(ls ../.__remote_jobid.[0-9]*_[0-9]* 2> /dev/null)
      if [ -n "${remoteJobIdFile}" ] ; then
         remoteJobIdFile=$(basename ${remoteJobIdFile})
         jobIdInstance=${remoteJobIdFile##*.}
         localJobId=${jobIdInstance%_*}
         instanceId=${jobIdInstance##*_}
         if [ ${instanceId} -ne 0 ] ; then
            exitStatus=1
         fi
      fi
   fi
fi

exit ${exitStatus}
