#!/bin/sh
#
# @package      hubzero-submit-distributor
# @file         Scripts/lsf/submitbatchjob.sh
# @author       Steven Clark <clarks@purdue.edu>
# @copyright    Copyright 2004-2015 HUBzero Foundation, LLC.
# @license      http://opensource.org/licenses/MIT MIT
#
# Copyright (c) 2004-2015 HUBzero Foundation, LLC.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# HUBzero is a registered trademark of HUBzero Foundation, LLC.
#
if [ $# -lt 3 ] ; then
   echo usage: $0 jobWorkingDirectory jobScratchDirectory jobDescriptionFile
   exit 64
fi

jobWorkingDirectory=$1
jobScratchDirectory=$2
jobDescriptionFile=$3

binPath=$(readlink -f $(dirname $0))
export PATH=${binPath}:${PATH}

cd ${jobWorkingDirectory}
exitStatus=$?

if [ ${exitStatus} -eq 0 ] ; then
   case ${jobDescriptionFile} in
      *.lsf)
         JOBID=`bsub < ${jobDescriptionFile} 2> /dev/null`
         exitStatus=$?
         if [ $# -gt 3 ] ; then
            logRecord=`date`
            shift 3
            while [ $# -gt 0 ] ; do
               logRecord=${logRecord}'\t'$1
               shift 1
            done
            logRecord=${logRecord}'\t'${JOBID}
            echo -e ${logRecord} >> ${HOME}/lsflog
         fi
         ;;
      *)
         echo "Invalid job class ${jobDescriptionFile}"
         exitStatus=23
         ;;
   esac
fi

if [ ${exitStatus} -eq 0 ] ; then
   echo "${JOBID}"
else
   echo "-1"
fi

exit ${exitStatus}
