#!/bin/sh
#
# @package      hubzero-submit-distributor
# @file         Scripts/ll/postprocessjob.sh
# @author       Steven Clark <clarks@purdue.edu>
# @copyright    Copyright 2004-2015 HUBzero Foundation, LLC.
# @license      http://opensource.org/licenses/MIT MIT
#
# Copyright (c) 2004-2015 HUBzero Foundation, LLC.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# HUBzero is a registered trademark of HUBzero Foundation, LLC.
#
if [ $# -ne 3 ] ; then
   echo usage: $0 jobWorkingDirectory jobScratchDirectory jobClass
   exit 64
fi

jobWorkingDirectory=$1
jobScratchDirectory=$2
jobClass=$3

exitStatus=0
if [ ! -d ${jobWorkingDirectory} ] ; then
   echo "Job working directory ${jobWorkingDirectory} does not exist"
   exitStatus=23
fi
if [ ! -d ${jobScratchDirectory} ] ; then
   echo "Job scratch directory ${jobScratchDirectory} does not exist"
   exitStatus=23
fi

if [ ${exitStatus} -eq 0 ] ; then
   case ${jobClass} in
      PEGASUS)
         cd ${jobScratchDirectory}
         exitStatus=$?
         if [ ${exitStatus} -eq 0 ] ; then
            if [ -f ${jobWorkingDirectory}/work/pegasusSetup.sh ] ; then
               . ${jobWorkingDirectory}/work/pegasusSetup.sh
            fi

            if [ -d work ] ; then
               propertiesFile=$(ls work/pegasus.[1-9]*.properties 2> /dev/null)
               if [ -n "${propertiesFile}" ] ; then
                  pegasusVersion=$(pegasus-version)
                  pegasus-analyzer --dir=work \
                                   --conf=${propertiesFile} > ${jobWorkingDirectory}/pegasus.analysis 2>&1

                  if [ "${pegasusVersion}" \> "4.0.0" ] ; then
                     pegasus-statistics --conf=${propertiesFile} \
                                        --statistics-level=jb_stats \
                                        --file=txt \
                                        --quiet \
                                        work
                     if [ -f work/statistics/jobs.txt ] ; then
                        mv work/statistics/jobs.txt ${jobWorkingDirectory}/pegasusjobstats.txt
                     fi
                     pegasus-statistics --conf=${propertiesFile} \
                                        --statistics-level=jb_stats \
                                        --file=csv \
                                        --quiet \
                                        work
                     if [ -f work/statistics/jobs.csv ] ; then
                        mv work/statistics/jobs.csv ${jobWorkingDirectory}/pegasusjobstats.csv
                     fi
                     pegasus-statistics --conf=${propertiesFile} \
                                        --statistics-level=summary \
                                        --file=csv \
                                        --quiet \
                                        work
                     if [ -f work/statistics/summary.csv ] ; then
                        mv work/statistics/summary.csv ${jobWorkingDirectory}/pegasussummary.csv
                     fi
                     if [ -f work/statistics/summary-time.csv ] ; then
                        mv work/statistics/summary-time.csv ${jobWorkingDirectory}/pegasussummary-time.csv
                     fi
                  else
                     pegasus-statistics --conf=${propertiesFile} \
                                        --statistics-level=jb_stats \
                                        --quiet \
                                        work
                     if [ -f work/statistics/jobs.csv ] ; then
                        mv work/statistics/jobs.csv ${jobWorkingDirectory}/pegasusjobstats.csv
                     fi
                     if [ -f work/statistics/jobs.txt ] ; then
                        mv work/statistics/jobs.txt ${jobWorkingDirectory}/pegasusjobstats.txt
                     fi
                  fi
               fi
            fi
            if [ ${jobScratchDirectory} != ${jobWorkingDirectory} ] ; then
               mkdir -p ${jobWorkingDirectory}/work
               cp -p work/jobstate.log ${jobWorkingDirectory}/work
               jobNames=$(grep JOB_TERMINATED work/jobstate.log | grep -v -E ' stage_| create_' | cut -d' ' -f 2)
               if [ -n "${jobNames}" ] ; then
                  for jobName in ${jobNames} ; do
                     cp -p work/${jobName}.out.[0-9]* ${jobWorkingDirectory}/work
                  done
               fi
            fi
         fi
         ;;
      *)
         echo "Invalid job class ${jobClass}"
         exitStatus=23
         ;;
   esac
fi

exit ${exitStatus}
