# @package      hubzero-submit-distributor
# @file         EnvironmentWhitelistInfo.py
# @author       Steven Clark <clarks@purdue.edu>
# @copyright    Copyright (c) 2012-2013 HUBzero Foundation, LLC.
# @license      http://www.gnu.org/licenses/lgpl-3.0.html LGPLv3
#
# Copyright (c) 2012-2013 HUBzero Foundation, LLC.
#
# This file is part of: The HUBzero(R) Platform for Scientific Collaboration
#
# The HUBzero(R) Platform for Scientific Collaboration (HUBzero) is free
# software: you can redistribute it and/or modify it under the terms of
# the GNU Lesser General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any
# later version.
#
# HUBzero is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# HUBzero is a registered trademark of HUBzero Foundation, LLC.
#

import os.path
import re

from hubzero.submit.LogMessage import logJobId as log

class EnvironmentWhitelistInfo:
   def __init__(self,
                infoDirectory,
                whiteListFile):
      self.environmentWhiteList = []

      commentPattern = re.compile('\s*#.*')

      whiteListPath = os.path.join(infoDirectory,whiteListFile)
      if os.path.exists(whiteListPath):
         fpWhiteList = open(whiteListPath,'r')
         if fpWhiteList:
            eof = False
            while not eof:
               record = fpWhiteList.readline()
               if record != "":
                  record = commentPattern.sub("",record).strip()
                  if record != "":
                     self.environmentWhiteList.append(record)
               else:
                  eof = True
            fpWhiteList.close()
      else:
         log("Environment white list file %s is missing" % (whiteListPath))


   def isVariableInWhiteList(self,
                             variable):
      return(variable in self.environmentWhiteList)


