#!/bin/sh
#
# @package      hubzero-submit-distributor
# @file         distributor.sh
# @author       Steven Clark <clarks@purdue.edu>
# @copyright    Copyright 2004-2013 HUBzero Foundation, LLC.
# @license      http://www.gnu.org/licenses/lgpl-3.0.html LGPLv3
#
# Copyright (c) 2004-2013 HUBzero Foundation, LLC.
#
# This file is part of: The HUBzero(R) Platform for Scientific Collaboration
#
# The HUBzero(R) Platform for Scientific Collaboration (HUBzero) is free
# software: you can redistribute it and/or modify it under the terms of
# the GNU Lesser General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any
# later version.
#
# HUBzero is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# HUBzero is a registered trademark of HUBzero Foundation, LLC.
#
echo Arguments are $0 $*
while :
do
  case $1 in
    -d)           echo Data "'$2'"; shift; shift;;
    -data)        echo Data "'$2'"; shift; shift;;
    -e)           echo Environment "'$2'"; shift; shift;;
    --env)        echo Environment "'$2'"; shift; shift;;
    -h)           echo Help ; shift;;
    --help)       echo Help ; shift;;
    -i)           echo Input file "'$2'"; shift; shift;;
    --inputfile)  echo Input file "'$2'"; shift; shift;;
    -j)           echo Jobid "'$2'"; shift; shift;;
    --jobid)      echo Jobid "'$2'"; shift; shift;;
    -l)           echo Local execution ; shift;;
    --local)      echo Local execution ; shift;;
    -M)           echo Metrics ; shift;;
    --metrics)    echo Metrics ; shift;;
    -m)           echo Manager "'$2'"; shift; shift;;
    --manager)    echo Manager "'$2'"; shift; shift;;
    -N)           echo CPUs/node "'$2'"; shift; shift;;
    --ppn)        echo CPUs/node "'$2'"; shift; shift;;
    -n)           echo Ncpus "'$2'"; shift; shift;;
    --nCpus)      echo Ncpus "'$2'"; shift; shift;;
    -o)           echo Output file "'$2'"; shift; shift;;
    --outputfile) echo Output file "'$2'"; shift; shift;;
    -p)           echo Parameters "'$2'"; shift; shift;;
    --parameters) echo Parameters "'$2'"; shift; shift;;
    -r)           echo Redundancy "'$2'"; shift; shift;;
    --redundancy) echo Redundancy "'$2'"; shift; shift;;
    -s)           echo Separator "'$2'"; shift; shift;;
    -separator)   echo Separator "'$2'"; shift; shift;;
    -v)           echo Venue "'$2'"; shift; shift;;
    --venue)      echo Venue "'$2'"; shift; shift;;
    -W)           echo Wait ; shift;;
    --wait)       echo Wait ; shift;;
    -w)           echo Walltime "'$2'"; shift; shift;;
    --walltime)   echo Walltime "'$2'"; shift; shift;;
    *) echo Command is "'$*'"; break;;
  esac
done

id

time $*
echo venue=submit status=5 cputime=3.3 realtime=6.6 1>&3

