#!/usr/bin/env tclsh
#
# @package      hubzero-submit-distributor
# @file         gensshkey.tcl
# @author       Steve Clark <clarks@purdue.edu>
# @copyright    Copyright 2004-2011 Purdue University. All rights reserved.
# @license      http://www.gnu.org/licenses/lgpl-3.0.html LGPLv3
#
# Copyright (c) 2004-2011 Purdue University
# All rights reserved.
#
# This file is part of: The HUBzero(R) Platform for Scientific Collaboration
#
# The HUBzero(R) Platform for Scientific Collaboration (HUBzero) is free
# software: you can redistribute it and/or modify it under the terms of
# the GNU Lesser General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any
# later version.
#
# HUBzero is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# HUBzero is a registered trademark of Purdue University.
#
package require Expect

set hubName HUB
set homeDir $::env(HOME)
if { [string match "/home/*" $homeDir] == 1 } {
   set hubDir [string range $homeDir 6 end]
   set locSlash [string first "/" $hubDir]
   if { $locSlash > 0 } {
      set hubName [string range $hubDir 0 [expr $locSlash - 1]]
   }
}

file mkdir etc
file attributes etc -permissions 0751
file mkdir .ssh
file attributes .ssh -permissions 0751
cd .ssh

set createSuccess 1

spawn -noecho ssh-keygen -t rsa -q -N "" -f submit_rsa -C "submit@$hubName.org"
expect {
   "submit_rsa already exists.*Overwrite (y/n)?" {
      send "n\r"
      set createSuccess 0
   }
   "Enter passphrase (empty for no passphrase): " {
      send "\r"
      exp_continue
   }
   "Enter same passphrase again: " {
      send "\r"
      exp_continue
   }
}

if { $createSuccess == 1 } {
   cd ../etc
   file copy ../.ssh/submit_rsa .
   file attributes submit_rsa -permissions 0644
}
