#
# @package      hubzero-submit-distributor
# @file         JobStatistic.py
# @author       Steve Clark <clarks@purdue.edu>
# @copyright    Copyright 2004-2011 Purdue University. All rights reserved.
# @license      http://www.gnu.org/licenses/lgpl-3.0.html LGPLv3
#
# Copyright (c) 2004-2011 Purdue University
# All rights reserved.
#
# This file is part of: The HUBzero(R) Platform for Scientific Collaboration
#
# The HUBzero(R) Platform for Scientific Collaboration (HUBzero) is free
# software: you can redistribute it and/or modify it under the terms of
# the GNU Lesser General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any
# later version.
#
# HUBzero is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# HUBzero is a registered trademark of Purdue University.
#
from UserDict import UserDict

class JobStatistic(UserDict):
   def __init__(self,
                nCores):
      UserDict.__init__(self)
      self['jobSubmissionMechanism'] = 'Unknown'
      self['remoteJobIdNumber']      = ''
      self['venue']                  = ''
      self['realTime']               = 0.
      self['userTime']               = 0.
      self['sysTime']                = 0.
      self['exitCode']               = 2
      self['transferCompleteTime']   = 0.
      self['jobStartedTime']         = 0.
      self['jobFinshedTime']         = 0.
      self['waitingTime']            = 0.
      self['elapsedRunTime']         = 0.
      self['nCores']                 = nCores


   def setWaitingTime(self):
      waitingTime = self['jobStartedTime'] - self['transferCompleteTime']
      self['waitingTime'] = max(waitingTime,0.)


   def setElapsedRunTime(self):
      elapsedRunTime = self['jobFinshedTime'] - self['jobStartedTime']
      self['elapsedRunTime'] = max(elapsedRunTime,0.)

