# @package      hubzero-submit-common
# @file         LogMessage.py
# @author       Steven Clark <clarks@purdue.edu>
# @copyright    Copyright (c) 2012-2015 HUBzero Foundation, LLC.
# @license      http://opensource.org/licenses/MIT MIT
#
# Copyright (c) 2012-2015 HUBzero Foundation, LLC.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# HUBzero is a registered trademark of HUBzero Foundation, LLC.
#
import sys
import os
import time
import logging
from io import IOBase

LOGMESSAGEFILE = sys.stdout
LOGJOBID       = 0

def getLogMessageFileNo():
   global LOGMESSAGEFILE

   logMessageFileNo = None
   if LOGMESSAGEFILE:
      try:
         isFile = isinstance(LOGMESSAGEFILE,file)
      except:
         isFile = isinstance(LOGMESSAGEFILE,IOBase)
      if isFile:
         logMessageFileNo = LOGMESSAGEFILE.fileno()

   return(logMessageFileNo)


def openLog(logName):
   global LOGMESSAGEFILE

   try:
      LOGMESSAGEFILE = open(logName,'a')
   except:
      LOGMESSAGEFILE = sys.stdout


def logSetMessageFile(fpMessageFile):
   global LOGMESSAGEFILE

   if LOGMESSAGEFILE:
      try:
         fileNo = LOGMESSAGEFILE.fileno()
      except:
         if type(LOGMESSAGEFILE).__name__ == 'OutStream':
            if LOGMESSAGEFILE != sys.stdout and \
               LOGMESSAGEFILE != sys.stderr:
               LOGMESSAGEFILE.close()
      else:
         if fileNo != sys.stdout.fileno() and \
            fileNo != sys.stderr.fileno():
            LOGMESSAGEFILE.close()

   LOGMESSAGEFILE = None
   if fpMessageFile:
      LOGMESSAGEFILE = fpMessageFile


def __logMessage(message):
   global LOGMESSAGEFILE

   if LOGMESSAGEFILE and message != "":
      LOGMESSAGEFILE.write("[%s] %s\n" % (time.ctime(),message))
      LOGMESSAGEFILE.flush()


def getLogMessage(message):
   logMessage = message

   return(logMessage)


def log(message):
   __logMessage(getLogMessage(message))


def getLogPIDMessage(message):
   logMessage = ""
   if message != "":
      logMessage = "(%d) %s" % (os.getpid(),message)

   return(logMessage)


def logPID(message):
   __logMessage(getLogPIDMessage(message))


def logSetJobId(jobId):
   global LOGJOBID

   LOGJOBID = jobId


def getLogJobIdMessage(message):
   global LOGJOBID

   logMessage = ""
   if message != "":
      logMessage = "%d: %s" % (LOGJOBID,message)

   return(logMessage)


def logJobId(message):
   __logMessage(getLogJobIdMessage(message))


def getLogIDMessage(message):
   global LOGJOBID

   logMessage = ""
   if message != "":
      if LOGJOBID > 0:
         logMessage = getLogJobIdMessage(message)
      else:
         logMessage = getLogPIDMessage(message)

   return(logMessage)


def logID(message):
   __logMessage(getLogIDMessage(message))


def isLogMessageFileStdout():
   global LOGMESSAGEFILE

   logMessageFileIsStdout = False
   if LOGMESSAGEFILE:
      try:
         isFile = isinstance(LOGMESSAGEFILE,file)
      except:
         isFile = isinstance(LOGMESSAGEFILE,IOBase)
         if isFile:
            if type(LOGMESSAGEFILE).__name__ == 'OutStream':
               if LOGMESSAGEFILE == sys.stdout:
                  logMessageFileIsStdout = True
      else:
         if isFile:
            if LOGMESSAGEFILE.fileno() == sys.stdout.fileno():
               logMessageFileIsStdout = True

   return(logMessageFileIsStdout)


def isLogMessageFileStderr():
   global LOGMESSAGEFILE

   logMessageFileIsStderr = False
   if LOGMESSAGEFILE:
      try:
         isFile = isinstance(LOGMESSAGEFILE,file)
      except:
         isFile = isinstance(LOGMESSAGEFILE,IOBase)
         if isFile:
            if type(LOGMESSAGEFILE).__name__ == 'OutStream':
               if LOGMESSAGEFILE == sys.stderr:
                  logMessageFileIsStderr = True
      else:
         if isFile:
            if LOGMESSAGEFILE.fileno() == sys.stderr.fileno():
               logMessageFileIsStderr = True

   return(logMessageFileIsStderr)


def isLoggingOn():
   global LOGMESSAGEFILE

   return(LOGMESSAGEFILE != None)


