# @package      hubzero-submit-common
# @file         TarCommand.py
# @author       Steven Clark <clarks@purdue.edu>
# @copyright    Copyright (c) 2012-2015 HUBzero Foundation, LLC.
# @license      http://opensource.org/licenses/MIT MIT
#
# Copyright (c) 2012-2015 HUBzero Foundation, LLC.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# HUBzero is a registered trademark of HUBzero Foundation, LLC.
#
import os.path

def __buildTarCommand(tarball,
                      tarOptions,
                      inputFiles,
                      useAbsolutePaths):
   absolutePaths = []
   for inputFile in inputFiles:
      absolutePath = os.path.abspath(inputFile)
      absolutePaths.append(absolutePath)

   absolutePaths.sort()

   tarCommandArgs = []
   tarCommandArgs.append("tar")
   tarCommandArgs.append(tarOptions)
   tarCommandArgs.append(tarball)
   tarCommandArgs.append("--exclude='*.svn*'")

   if useAbsolutePaths:
      for absolutePath in absolutePaths:
         tarCommandArgs.append(absolutePath)
   else:
      oldDirName = ""
      for absolutePath in absolutePaths:
         dirName  = os.path.dirname(absolutePath)
         baseName = os.path.basename(absolutePath)
         if dirName != oldDirName:
            tarCommandArgs.append("-C")
            tarCommandArgs.append(dirName)
            oldDirName = dirName
         tarCommandArgs.append(baseName)

   return(tarCommandArgs)


def buildCreate(tarball,
                inputFiles,
                useAbsolutePaths=False):
   tarCommand = __buildTarCommand(tarball,'vchf',inputFiles,useAbsolutePaths)

   return(tarCommand)


def buildAppend(tarball,
                inputFiles,
                useAbsolutePaths=False):
   tarCommand = __buildTarCommand(tarball,'vrhf',inputFiles,useAbsolutePaths)

   return(tarCommand)


