# @package      hubzero-submit-common
# @file         LogMessage.py
# @author       Steven Clark <clarks@purdue.edu>
# @copyright    Copyright (c) 2012-2014 HUBzero Foundation, LLC.
# @license      http://www.gnu.org/licenses/lgpl-3.0.html LGPLv3
#
# Copyright (c) 2012-2014 HUBzero Foundation, LLC.
#
# This file is part of: The HUBzero(R) Platform for Scientific Collaboration
#
# The HUBzero(R) Platform for Scientific Collaboration (HUBzero) is free
# software: you can redistribute it and/or modify it under the terms of
# the GNU Lesser General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any
# later version.
#
# HUBzero is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# HUBzero is a registered trademark of HUBzero Foundation, LLC.
#

import sys
import os
import time
import logging

LOGMESSAGEFILE = sys.stdout
LOGJOBID       = 0

def getLogMessageFileNo():
   global LOGMESSAGEFILE

   logMessageFileNo = None
   if LOGMESSAGEFILE:
      logMessageFileNo = LOGMESSAGEFILE.fileno()

   return(logMessageFileNo)


def openLog(logName):
   global LOGMESSAGEFILE

   try:
      LOGMESSAGEFILE = open(logName,'a')
   except:
      LOGMESSAGEFILE = sys.stdout


def logSetMessageFile(fpMessageFile):
   global LOGMESSAGEFILE

   if LOGMESSAGEFILE:
      if LOGMESSAGEFILE.fileno() != sys.stdout.fileno() and \
         LOGMESSAGEFILE.fileno() != sys.stderr.fileno():
         LOGMESSAGEFILE.close()
   LOGMESSAGEFILE = None

   if fpMessageFile:
      LOGMESSAGEFILE = fpMessageFile



def __logMessage(message):
   global LOGMESSAGEFILE

   if LOGMESSAGEFILE and message != "":
      LOGMESSAGEFILE.write("[%s] %s\n" % (time.ctime(),message))
      LOGMESSAGEFILE.flush()


def getLogMessage(message):
   logMessage = message

   return(logMessage)


def log(message):
   __logMessage(getLogMessage(message))


def getLogPIDMessage(message):
   logMessage = ""
   if message != "":
      logMessage = "(%d) %s" % (os.getpid(),message)

   return(logMessage)


def logPID(message):
   __logMessage(getLogPIDMessage(message))


def logSetJobId(jobId):
   global LOGJOBID

   LOGJOBID = jobId


def getLogJobIdMessage(message):
   global LOGJOBID

   logMessage = ""
   if message != "":
      logMessage = "%d: %s" % (LOGJOBID,message)

   return(logMessage)


def logJobId(message):
   __logMessage(getLogJobIdMessage(message))


def getLogIDMessage(message):
   global LOGJOBID

   logMessage = ""
   if message != "":
      if LOGJOBID > 0:
         logMessage = getLogJobIdMessage(message)
      else:
         logMessage = getLogPIDMessage(message)

   return(logMessage)


def logID(message):
   __logMessage(getLogIDMessage(message))


def isLogMessageFileStdout():
   global LOGMESSAGEFILE

   logMessageFileIsStdout = False
   if LOGMESSAGEFILE:
      if LOGMESSAGEFILE.fileno() == sys.stdout.fileno():
         logMessageFileIsStdout = True

   return(logMessageFileIsStdout)


def isLogMessageFileStderr():
   global LOGMESSAGEFILE

   logMessageFileIsStderr = False
   if LOGMESSAGEFILE:
      if LOGMESSAGEFILE.fileno() == sys.stderr.fileno():
         logMessageFileIsStderr = True

   return(logMessageFileIsStderr)


def isLoggingOn():
   global LOGMESSAGEFILE

   return(LOGMESSAGEFILE != None)


