#
# Copyright (c) 2004-2011 Purdue University All rights reserved.
#
# Developed by: HUBzero Technology Group, Purdue University
#               http://hubzero.org
#
# HUBzero is free software: you can redistribute it and/or modify it under the terms of the
# GNU Lesser General Public License as published by the Free Software Foundation, either
# version 3 of the License, or (at your option) any later version.
#
# HUBzero is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
# without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the GNU Lesser General Public License for more details.  You should have received a
# copy of the GNU Lesser General Public License along with HUBzero.
# If not, see <http://www.gnu.org/licenses/>.
#
# GNU LESSER GENERAL PUBLIC LICENSE
# Version 3, 29 June 2007
# Copyright (C) 2007 Free Software Foundation, Inc. <http://fsf.org/>
#
import os
import getpass

class ClientIdAuthAttributes:
   def __init__(self):
      self.sessionAttributes = {}
      self.userAttributes    = {}

      if "SESSIONDIR" in os.environ:
         resourcePath = os.path.join(os.environ['SESSIONDIR'],'resources')
         self.getSessionAttributes(resourcePath)

      if not 'token' in self.sessionAttributes:
         resourcePath = os.path.join(os.environ['HOME'],'.default_resources')
         self.getSessionAttributes(resourcePath)

      self.getUserAttributes()


   def getSessionAttributes(self,
                            resourcePath):
      del self.sessionAttributes
      self.sessionAttributes = {}

      try:
         if(os.path.exists(resourcePath)):
            fpResource = open(resourcePath,'r')
            if fpResource:
               eof = False
               while not eof:
                  record = fpResource.readline()
                  if record != "":
                     if   record.startswith('session_token '):
                        self.sessionAttributes['token'] = record.split()[1]
                     elif record.startswith('username '):
                        self.sessionAttributes['username'] = record.split()[1]
                     elif record.startswith('submit_target '):
                        if not 'serverTarget' in self.sessionAttributes:
                           self.sessionAttributes['serverTarget'] = []
                        self.sessionAttributes['serverTarget'].append(record.split()[1])
                  else:
                     eof = True
               fpResource.close()
      except:
         pass


   def getUserAttributes(self):
      del self.userAttributes
      self.userAttributes = {}

      self.userAttributes['username'] = getpass.getuser()
      haveToken = 'token' in self.sessionAttributes
      if not haveToken:
         try:
            username = raw_input("Username: (%s) " % (self.userAttributes['username']))
            if username != "":
               self.userAttributes['username'] = username
            password = getpass.getpass("Password: ")
            if password != "":
               self.userAttributes['password'] = password
         except EOFError:
            pass
         except KeyboardInterrupt:
            pass


   def haveIdAuthAttributes(self):
      haveAttributes = False
      if   'token' in self.sessionAttributes:
         haveAttributes = True
      elif 'username' in self.userAttributes and 'password' in self.userAttributes:
         haveAttributes = True

      return(haveAttributes)


   def getSignonAttributes(self):
      signonAttributes = {}
      signonAttributes['username']    = self.userAttributes['username']
      if 'password' in self.userAttributes:
         signonAttributes['password'] = self.userAttributes['password']
      if 'token' in self.sessionAttributes:
         signonAttributes['token']    = self.sessionAttributes['token']

      return(signonAttributes)


   def clearSessionToken(self):
      if 'token' in self.sessionAttributes:
         del self.sessionAttributes['token']


