#
# Copyright (c) 2004-2011 Purdue University All rights reserved.
# 
# Developed by: HUBzero Technology Group, Purdue University
#               http://hubzero.org
# 
# HUBzero is free software: you can redistribute it and/or modify it under the terms of the
# GNU Lesser General Public License as published by the Free Software Foundation, either
# version 3 of the License, or (at your option) any later version.
# 
# HUBzero is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
# without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the GNU Lesser General Public License for more details.  You should have received a
# copy of the GNU Lesser General Public License along with HUBzero.
# If not, see <http://www.gnu.org/licenses/>.
# 
# GNU LESSER GENERAL PUBLIC LICENSE
# Version 3, 29 June 2007
# Copyright (C) 2007 Free Software Foundation, Inc. <http://fsf.org/>
#
from hubzero.submit.LogMessage  import logID as log
from hubzero.submit.MessageCore import MessageCore

class RemoteTunnelMonitor(MessageCore):
   def __init__(self,
                host,
                port,
                repeatDelay=5,
                fixedBufferSize=64):
      MessageCore.__init__(self,listenerHost=host,listenerPort=port,repeatDelay=repeatDelay)
      self.fixedBufferSize = fixedBufferSize


   def getTunnelAddressPort(self,
                            tunnelName):
      address = ""
      port    = ""

      queryMessage = "A:" + tunnelName
      nTry,response = self.requestMessageResponse(queryMessage,
                                                  self.fixedBufferSize,
                                                  self.fixedBufferSize,
                                                  True)

      if nTry > 1:
         log("confirmation: A(%d):%s" % (nTry,response))

      if response != "":
         address,port = response.split()

      return(address,port)


   def incrementTunnelUse(self,
                          tunnelName):
      useCount = ""

      queryMessage = "I:" + tunnelName
      nTry,response = self.requestMessageResponse(queryMessage,
                                                  self.fixedBufferSize,
                                                  self.fixedBufferSize,
                                                  True)

      if nTry > 1:
         log("confirmation: I(%d):%s" % (nTry,response))

      if response != "":
         useCount = response.strip()

      return(useCount)


   def decrementTunnelUse(self,
                          tunnelName):
      useCount = ""

      queryMessage = "D:" + tunnelName
      nTry,response = self.requestMessageResponse(queryMessage,
                                                  self.fixedBufferSize,
                                                  self.fixedBufferSize,
                                                  True)

      if nTry > 1:
         log("confirmation: D(%d):%s" % (nTry,response))

      if response != "":
         useCount = response.strip()

      return(useCount)


   def terminateTunnelUse(self,
                          tunnelName):
      useCount = ""

      queryMessage = "T:" + tunnelName
      nTry,response = self.requestMessageResponse(queryMessage,
                                                  self.fixedBufferSize,
                                                  self.fixedBufferSize,
                                                  True)

      if nTry > 1:
         log("confirmation: T(%d):%s" % (nTry,response))

      if response != "":
         useCount = response.strip()

      return(useCount)


   def reportTunnelUse(self,
                       tunnelName=""):
      report = ""

      queryMessage = "R:" + tunnelName
      nTry,report = self.requestMessageVariableResponse(queryMessage,
                                                        self.fixedBufferSize,
                                                        self.fixedBufferSize,
                                                        True)

      if nTry > 1:
         log("confirmation: R(%d): %d" % (nTry,len(report)))

      return(report.strip())


