#
# Copyright (c) 2004-2011 Purdue University All rights reserved.
#
# Developed by: HUBzero Technology Group, Purdue University
#               http://hubzero.org
#
# HUBzero is free software: you can redistribute it and/or modify it under the terms of the
# GNU Lesser General Public License as published by the Free Software Foundation, either
# version 3 of the License, or (at your option) any later version.
#
# HUBzero is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
# without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the GNU Lesser General Public License for more details.  You should have received a
# copy of the GNU Lesser General Public License along with HUBzero.
# If not, see <http://www.gnu.org/licenses/>.
#
# GNU LESSER GENERAL PUBLIC LICENSE
# Version 3, 29 June 2007
# Copyright (C) 2007 Free Software Foundation, Inc. <http://fsf.org/>
#
import time
import MySQLdb

from hubzero.submit.LogMessage import logID as log

class MySQLDatabase:
   def __init__(self,
                mysqlHost="",
                mysqlUser="",
                mysqlPassword="",
                mysqlDB=""):
      self.mysqlHost     = mysqlHost
      self.mysqlUser     = mysqlUser
      self.mysqlPassword = mysqlPassword
      self.mysqlDB       = mysqlDB
      self.db            = None
      self.cursor        = None


   def connect(self,
               maximumAttempts=8):
      if self.db:
         connected = True
      else:
         connected = False
         attempts = 0
         delay = 1
         maxdelay = 256
         while attempts < maximumAttempts:
            try:
               attempts += 1
               self.db = MySQLdb.connect(host=self.mysqlHost,
                                         user=self.mysqlUser,
                                         passwd=self.mysqlPassword,
                                         db=self.mysqlDB)
               self.cursor = self.db.cursor()
               connected = True
               break
            except MySQLdb.Error, err:
               log("Exception in MySQLDatabase.connect: %d %s" % (err.args[0],err.args[1]))

            time.sleep(delay)
            if delay < maxdelay:
               delay = delay * 2

      return(connected)


   def disconnect(self):
      if self.db:
         self.db.close()
         self.db = None


   def select(self,
              sqlCommand):
      result = ()
      try:
         count = self.cursor.execute(sqlCommand)
         result = self.cursor.fetchall()
      except MySQLdb.MySQLError, (num, expl):
         log("%s.  SQL was: %s" % (expl,sqlCommand))
      except:
         log("Some other MySQL exception.")

      return(result)


   def update(self,
              sqlCommand):
      result = ""
      try:
         count = self.cursor.execute(sqlCommand)
      except MySQLdb.MySQLError, (num, expl):
         result = expl

      return(result)


   def insert(self,
              sqlCommand):
      result = ""
      try:
         count = self.cursor.execute(sqlCommand)
      except MySQLdb.MySQLError, (num, expl):
         result = expl

      return(result)


   def delete(self,
              sqlCommand):
      result = ""
      try:
         count = self.cursor.execute(sqlCommand)
      except MySQLdb.MySQLError, (num, expl):
         result = expl

      return(result)


