# @package      hubzero-submit-client
# @file         ProbeQueue.py
# @copyright    Copyright (c) 2012-2020 The Regents of the University of California.
# @license      http://opensource.org/licenses/MIT MIT
#
# Copyright (c) 2012-2020 The Regents of the University of California.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# HUBzero is a registered trademark of The Regents of the University of California.
#
class ProbeQueue:
   def __init__(self):
      self.items = []


   def purge(self):
      del self.items
      self.items = []


   def isEmpty(self):
      return(self.items == [])


   def add(self,item):
      self.items.append(item)


   def pop(self):
      locMin = 0
      for i1 in range(1,len(self.items)):
         if self.items[i1] < self.items[locMin]:
            locMin = i1
      item = self.items[locMin]
      self.items[locMin:locMin+1] = []

      return(item)


   def peek(self):
      locMin = 0
      for i1 in range(1,len(self.items)):
         if self.items[i1] < self.items[locMin]:
            locMin = i1
      item = self.items[locMin]

      return(item)


   def getId(self,id):
      item = None
      for i1 in range(0,len(self.items)):
         if self.items[i1].id == id:
            item = self.items[i1]
            self.items[i1:i1+1] = []
            break

      return(item)


   def getDestination(self,destination):
      item = None
      for i1 in range(0,len(self.items)):
         if self.items[i1].destination == destination:
            item = self.items[i1]
            self.items[i1:i1+1] = []
            break

      return(item)


   def show(self):
      report = []
      for i1 in range(0,len(self.items)):
         report.append(self.items[i1].show())
      reportMessage = '\n'.join(report)
      del report

      return(reportMessage)


   def dump(self,dumpFilePath):
      try:
         if not self.isEmpty():
            fpDumpFile = open(dumpFilePath,'w')
            fpDumpFile.write(self.show() + '\n')
            fpDumpFile.close()
      except:
         pass


   def getDestinations(self):
      destinations = []
      for i1 in range(0,len(self.items)):
         if not self.items[i1].destination in destinations:
            destinations.append(self.items[i1].destination)

      return(destinations)


