'\"
'\" Generated from file '../../runtime/tcllib-1.12/modules/struct/matrix.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2002 Andreas Kupries <andreas_kupries@users.sourceforge.net>
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2009/01/30 04:56:47 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "struct::matrix" n 2.0.1 struct "Tcl Data Structures"
.BS
.SH NAME
struct::matrix \- Create and manipulate matrix objects
.SH SYNOPSIS
package require \fBTcl  8.2\fR
.sp
package require \fBstruct::matrix  ?2.0.1?\fR
.sp
\fB::struct::matrix\fR ?\fImatrixName\fR? ?\fB=\fR|\fB:=\fR|\fBas\fR|\fBdeserialize\fR \fIsource\fR?
.sp
\fBmatrixName\fR \fIoption\fR ?\fIarg arg ...\fR?
.sp
\fImatrixName\fR \fB=\fR \fIsourcematrix\fR
.sp
\fImatrixName\fR \fB-->\fR \fIdestmatrix\fR
.sp
\fImatrixName\fR \fBadd column\fR ?\fIvalues\fR?
.sp
\fImatrixName\fR \fBadd row\fR ?\fIvalues\fR?
.sp
\fImatrixName\fR \fBadd columns\fR \fIn\fR
.sp
\fImatrixName\fR \fBadd rows\fR \fIn\fR
.sp
\fImatrixName\fR \fBcells\fR
.sp
\fImatrixName\fR \fBcellsize\fR \fIcolumn row\fR
.sp
\fImatrixName\fR \fBcolumns\fR
.sp
\fImatrixName\fR \fBcolumnwidth\fR \fIcolumn\fR
.sp
\fImatrixName\fR \fBdelete column\fR \fIcolumn\fR
.sp
\fImatrixName\fR \fBdelete columns\fR \fIn\fR
.sp
\fImatrixName\fR \fBdelete row\fR \fIrow\fR
.sp
\fImatrixName\fR \fBdelete rows\fR \fIn\fR
.sp
\fImatrixName\fR \fBdeserialize\fR \fIserialization\fR
.sp
\fImatrixName\fR \fBdestroy\fR
.sp
\fImatrixName\fR \fBformat 2string\fR ?\fIreport\fR?
.sp
\fImatrixName\fR \fBformat 2chan\fR ??\fIreport\fR? \fIchannel\fR?
.sp
\fImatrixName\fR \fBget cell\fR \fIcolumn row\fR
.sp
\fImatrixName\fR \fBget column\fR \fIcolumn\fR
.sp
\fImatrixName\fR \fBget rect\fR \fIcolumn_tl row_tl column_br row_br\fR
.sp
\fImatrixName\fR \fBget row\fR \fIrow\fR
.sp
\fImatrixName\fR \fBinsert column\fR \fIcolumn\fR ?\fIvalues\fR?
.sp
\fImatrixName\fR \fBinsert row\fR \fIrow\fR ?\fIvalues\fR?
.sp
\fImatrixName\fR \fBlink\fR ?-transpose? \fIarrayvar\fR
.sp
\fImatrixName\fR \fBlinks\fR
.sp
\fImatrixName\fR \fBrowheight\fR \fIrow\fR
.sp
\fImatrixName\fR \fBrows\fR
.sp
\fImatrixName\fR \fBsearch\fR ?-nocase? ?-exact|-glob|-regexp? \fBall\fR \fIpattern\fR
.sp
\fImatrixName\fR \fBsearch\fR ?-nocase? ?-exact|-glob|-regexp? \fBcolumn\fR \fIcolumn pattern\fR
.sp
\fImatrixName\fR \fBsearch\fR ?-nocase? ?-exact|-glob|-regexp? \fBrow\fR \fIrow pattern\fR
.sp
\fImatrixName\fR \fBsearch\fR ?-nocase? ?-exact|-glob|-regexp? \fBrect\fR \fIcolumn_tl row_tl column_br row_br pattern\fR
.sp
\fImatrixName\fR \fBserialize\fR ?\fIcolumn_tl row_tl column_br row_br\fR?
.sp
\fImatrixName\fR \fBset cell\fR \fIcolumn row value\fR
.sp
\fImatrixName\fR \fBset column\fR \fIcolumn values\fR
.sp
\fImatrixName\fR \fBset rect\fR \fIcolumn row values\fR
.sp
\fImatrixName\fR \fBset row\fR \fIrow values\fR
.sp
\fImatrixName\fR \fBsort columns\fR ?\fB-increasing\fR|\fB-decreasing\fR? \fIrow\fR
.sp
\fImatrixName\fR \fBsort rows\fR ?\fB-increasing\fR|\fB-decreasing\fR? \fIcolumn\fR
.sp
\fImatrixName\fR \fBswap columns\fR \fIcolumn_a column_b\fR
.sp
\fImatrixName\fR \fBswap rows\fR \fIrow_a row_b\fR
.sp
\fImatrixName\fR \fBtranspose\fR
.sp
\fImatrixName\fR \fBunlink\fR \fIarrayvar\fR
.sp
.BE
.SH DESCRIPTION
.PP
A matrix is a rectangular collection of cells, i.e. organized in rows
and columns. Each cell contains exactly one value of arbitrary
form. The cells in the matrix are addressed by pairs of integer
numbers, with the first (left) number in the pair specifying the
column and the second (right) number specifying the row the cell is
in. These indices are counted from 0 upward. The special non-numeric
index \fBend\fR refers to the last row or column in the matrix,
depending on the context. Indices of the form
\fBend\fR-\fBnumber\fR are counted from the end of the row or
column, like they are for standard Tcl lists. Trying to access
non-existing cells causes an error.
.PP
The matrices here are created empty, i.e. they have neither rows nor
columns. The user then has to add rows and columns as needed by his
application. A specialty of this structure is the ability to export an
array-view onto its contents. Such can be used by tkTable, for
example, to link the matrix into the display.
.PP
The main command of the package is:
.TP
\fB::struct::matrix\fR ?\fImatrixName\fR? ?\fB=\fR|\fB:=\fR|\fBas\fR|\fBdeserialize\fR \fIsource\fR?
The command creates a new matrix object with an associated global Tcl
command whose name is \fImatrixName\fR.  This command may be used to
invoke various operations on the matrix.  It has the following general
form:
.RS
.TP
\fBmatrixName\fR \fIoption\fR ?\fIarg arg ...\fR?
\fIOption\fR and the \fIarg\fRs determine the exact behavior of the
command.
.RE
.sp
If \fImatrixName\fR is not specified a unique name will be generated
by the package itself. If a \fIsource\fR is specified the new matrix
will be initialized to it. For the operators \fB=\fR, \fB:=\fR,
and \fBas\fR the argument \fIsource\fR is interpreted as the name of
another matrix object, and the assignment operator \fB=\fR will be
executed. For \fBdeserialize\fR the \fIsource\fR is a serialized
matrix object and \fBdeserialize\fR will be executed.
.sp
In other words
.sp
.nf

    ::struct::matrix mymatrix = b

.fi
.sp
is equivalent to
.sp
.nf

    ::struct::matrix mymatrix
    mymatrix = b

.fi
.sp
and
.sp
.nf

    ::struct::matrix mymatrix deserialize $b

.fi
.sp
is equivalent to
.sp
.nf

    ::struct::matrix mymatrix
    mymatrix deserialize $b

.fi
.PP
.PP
The following commands are possible for matrix objects:
.TP
\fImatrixName\fR \fB=\fR \fIsourcematrix\fR
This is the assignment operator for matrix objects. It copies the matrix
contained in the matrix object \fIsourcematrix\fR over the matrix data in
\fImatrixName\fR. The old contents of \fImatrixName\fR are deleted by
this operation.
.sp
This operation is in effect equivalent to
.sp
.nf

    \fImatrixName\fR \fBdeserialize\fR [\fIsourcematrix\fR \fBserialize\fR]

.fi
.TP
\fImatrixName\fR \fB-->\fR \fIdestmatrix\fR
This is the reverse assignment operator for matrix objects. It copies
the matrix contained in the matrix object \fImatrixName\fR over the matrix
data in the object \fIdestmatrix\fR.
The old contents of \fIdestmatrix\fR are deleted by this operation.
.sp
This operation is in effect equivalent to
.sp
.nf

    \fIdestmatrix\fR \fBdeserialize\fR [\fImatrixName\fR \fBserialize\fR]

.fi
.TP
\fImatrixName\fR \fBadd column\fR ?\fIvalues\fR?
Extends the matrix by one column and then acts like \fBset column\fR
(see below) on this new column if there were \fIvalues\fR
supplied. Without \fIvalues\fR the new cells will be set to the empty
string. The new column is appended immediately behind the last
existing column.
.TP
\fImatrixName\fR \fBadd row\fR ?\fIvalues\fR?
Extends the matrix by one row and then acts like \fBset row\fR (see
below) on this new row if there were \fIvalues\fR supplied. Without
\fIvalues\fR the new cells will be set to the empty string. The new
row is appended immediately behind the last existing row.
.TP
\fImatrixName\fR \fBadd columns\fR \fIn\fR
Extends the matrix by \fIn\fR columns. The new cells will be set to
the empty string. The new columns are appended immediately behind the
last existing column. A value of \fIn\fR equal to or smaller than 0 is
not allowed.
.TP
\fImatrixName\fR \fBadd rows\fR \fIn\fR
Extends the matrix by \fIn\fR rows. The new cells will be set to the
empty string. The new rows are appended immediately behind the last
existing row. A value of \fIn\fR equal to or smaller than 0 is not
allowed.
.TP
\fImatrixName\fR \fBcells\fR
Returns the number of cells currently managed by the matrix. This is
the product of \fBrows\fR and \fBcolumns\fR.
.TP
\fImatrixName\fR \fBcellsize\fR \fIcolumn row\fR
Returns the length of the string representation of the value currently
contained in the addressed cell.
.TP
\fImatrixName\fR \fBcolumns\fR
Returns the number of columns currently managed by the matrix.
.TP
\fImatrixName\fR \fBcolumnwidth\fR \fIcolumn\fR
Returns the length of the longest string representation of all the
values currently contained in the cells of the addressed column if
these are all spanning only one line. For cell values spanning
multiple lines the length of their longest line goes into the
computation.
.TP
\fImatrixName\fR \fBdelete column\fR \fIcolumn\fR
Deletes the specified column from the matrix and shifts all columns
with higher indices one index down.
.TP
\fImatrixName\fR \fBdelete columns\fR \fIn\fR
Deletes \fIn\fR columns from the right of the matrix. The value of
\fIn\fR has to satisfy the constraint
"0 < \fIn\fR < [\fBmatrixName\fR \fBcolumns\fR]"
.TP
\fImatrixName\fR \fBdelete row\fR \fIrow\fR
Deletes the specified row from the matrix and shifts all row with
higher indices one index down.
.TP
\fImatrixName\fR \fBdelete rows\fR \fIn\fR
Deletes \fIn\fR rows from the bottom of the matrix. The value of
\fIn\fR has to satisfy the constraint
"0 < \fIn\fR < [\fBmatrixName\fR \fBrows\fR]"
.TP
\fImatrixName\fR \fBdeserialize\fR \fIserialization\fR
This is the complement to \fBserialize\fR. It replaces matrix data
in \fImatrixName\fR with the matrix described by the \fIserialization\fR
value. The old contents of \fImatrixName\fR are deleted by this
operation.
.TP
\fImatrixName\fR \fBdestroy\fR
Destroys the matrix, including its storage space and associated
command.
.TP
\fImatrixName\fR \fBformat 2string\fR ?\fIreport\fR?
Formats the matrix using the specified report object and returns the
string containing the result of this operation. The report has to
support the \fBprintmatrix\fR method. If no \fIreport\fR is
specified the system will use an internal report definition to format
the matrix.
.TP
\fImatrixName\fR \fBformat 2chan\fR ??\fIreport\fR? \fIchannel\fR?
Formats the matrix using the specified report object and writes the
string containing the result of this operation into the channel. The
report has to support the \fBprintmatrix2channel\fR method.  If no
\fIreport\fR is specified the system will use an internal report
definition to format the matrix. If no \fIchannel\fR is specified the
system will use \fBstdout\fR.
.TP
\fImatrixName\fR \fBget cell\fR \fIcolumn row\fR
Returns the value currently contained in the cell identified by row
and column index.
.TP
\fImatrixName\fR \fBget column\fR \fIcolumn\fR
Returns a list containing the values from all cells in the column
identified by the index. The contents of the cell in row 0 are stored
as the first element of this list.
.TP
\fImatrixName\fR \fBget rect\fR \fIcolumn_tl row_tl column_br row_br\fR
Returns a list of lists of cell values. The values stored in the
result come from the sub-matrix whose top-left and bottom-right cells
are specified by \fIcolumn_tl, row_tl\fR and
\fIcolumn_br, row_br\fR resp. Note that the following equations have
to be true: "\fIcolumn_tl\fR <= \fIcolumn_br\fR" and "\fIrow_tl\fR <=
\fIrow_br\fR". The result is organized as follows: The outer list is
the list of rows, its elements are lists representing a single
row. The row with the smallest index is the first element of the outer
list. The elements of the row lists represent the selected cell
values. The cell with the smallest index is the first element in each
row list.
.TP
\fImatrixName\fR \fBget row\fR \fIrow\fR
Returns a list containing the values from all cells in the row
identified by the index. The contents of the cell in column 0 are
stored as the first element of this list.
.TP
\fImatrixName\fR \fBinsert column\fR \fIcolumn\fR ?\fIvalues\fR?
Extends the matrix by one column and then acts like \fBset column\fR
(see below) on this new column if there were \fIvalues\fR
supplied. Without \fIvalues\fR the new cells will be set to the empty
string. The new column is inserted just before the column specified by
the given index. This means, if \fIcolumn\fR is less than or equal to
zero, then the new column is inserted at the beginning of the matrix,
before the first column. If \fIcolumn\fR has the value \fBend\fR,
or if it is greater than or equal to the number of columns in the
matrix, then the new column is appended to the matrix, behind the last
column. The old column at the chosen index and all columns with higher
indices are shifted one index upward.
.TP
\fImatrixName\fR \fBinsert row\fR \fIrow\fR ?\fIvalues\fR?
Extends the matrix by one row and then acts like \fBset row\fR (see
below) on this new row if there were \fIvalues\fR supplied. Without
\fIvalues\fR the new cells will be set to the empty string. The new
row is inserted just before the row specified by the given index. This
means, if \fIrow\fR is less than or equal to zero, then the new row is
inserted at the beginning of the matrix, before the first row. If
\fIrow\fR has the value \fBend\fR, or if it is greater than or
equal to the number of rows in the matrix, then the new row is
appended to the matrix, behind the last row. The old row at that index
and all rows with higher indices are shifted one index upward.
.TP
\fImatrixName\fR \fBlink\fR ?-transpose? \fIarrayvar\fR
Links the matrix to the specified array variable. This means that the
contents of all cells in the matrix is stored in the array too, with
all changes to the matrix propagated there too. The contents of the
cell \fI(column,row)\fR is stored in the array using the key
\fIcolumn,row\fR. If the option \fB-transpose\fR is specified the
key \fIrow,column\fR will be used instead. It is possible to link the
matrix to more than one array. Note that the link is bidirectional,
i.e. changes to the array are mirrored in the matrix too.
.TP
\fImatrixName\fR \fBlinks\fR
Returns a list containing the names of all array variables the matrix
was linked to through a call to method \fBlink\fR.
.TP
\fImatrixName\fR \fBrowheight\fR \fIrow\fR
Returns the height of the specified row in lines. This is the highest
number of lines spanned by a cell over all cells in the row.
.TP
\fImatrixName\fR \fBrows\fR
Returns the number of rows currently managed by the matrix.
.TP
\fImatrixName\fR \fBsearch\fR ?-nocase? ?-exact|-glob|-regexp? \fBall\fR \fIpattern\fR
Searches the whole matrix for cells matching the \fIpattern\fR and
returns a list with all matches. Each item in the aforementioned list
is a list itself and contains the column and row index of the matching
cell, in this order. The results are ordered by column first and row
second, both times in ascending order. This means that matches to the
left and the top of the matrix come before matches to the right and
down.
.sp
The type of the pattern (string, glob, regular expression) is
determined by the option after the \fBsearch\fR keyword. If no
option is given it defaults to \fB-exact\fR.
.sp
If the option \fB-nocase\fR is specified the search will be
case-insensitive.
.TP
\fImatrixName\fR \fBsearch\fR ?-nocase? ?-exact|-glob|-regexp? \fBcolumn\fR \fIcolumn pattern\fR
Like \fBsearch all\fR, but the search is restricted to the
specified column.
.TP
\fImatrixName\fR \fBsearch\fR ?-nocase? ?-exact|-glob|-regexp? \fBrow\fR \fIrow pattern\fR
Like \fBsearch all\fR, but the search is restricted to the
specified row.
.TP
\fImatrixName\fR \fBsearch\fR ?-nocase? ?-exact|-glob|-regexp? \fBrect\fR \fIcolumn_tl row_tl column_br row_br pattern\fR
Like \fBsearch all\fR, but the search is restricted to the
specified rectangular area of the matrix.
.TP
\fImatrixName\fR \fBserialize\fR ?\fIcolumn_tl row_tl column_br row_br\fR?
This method serializes the sub-matrix spanned up by the rectangle
specification. In other words it returns a tcl \fIvalue\fR completely
describing that matrix. If no rectangle is specified the whole matrix
will be serialized.
This allows, for example, the transfer of matrix objects (or parts
thereof) over arbitrary channels, persistence, etc.
This method is also the basis for both the copy constructor and the
assignment operator.
.sp
The result of this method has to be semantically identical over all
implementations of the matrix interface. This is what will enable us
to copy matrix data between different implementations of the same
interface.
.sp
The result is a list containing exactly three items.
.sp
The first two elements of the list specify the number of rows and
columns of the matrix, in that order. The values integer numbers
greater than or equal to zero.
.sp
The last element of the list contains the values of the matrix cells
we have serialized, in the form of a value like it is returned by the
\fBget rect\fR. However empty cells to the right and bottom of
the matrix can be left out of that value as the size information in
the serialization allows the receiver the creation of a matrix with
the proper size despite the missing values.
.nf

    # A possible serialization for the matrix structure
    #
    # | a b d g |
    # | c e     |
    # | f       |
    #
    # is
    #
    # 3 4 {{a b d g} {c e} {f}}

.fi
.sp
.TP
\fImatrixName\fR \fBset cell\fR \fIcolumn row value\fR
Sets the value in the cell identified by row and column index to the
data in the third argument.
.TP
\fImatrixName\fR \fBset column\fR \fIcolumn values\fR
Sets the values in the cells identified by the column index to the
elements of the list provided as the third argument. Each element of
the list is assigned to one cell, with the first element going into
the cell in row 0 and then upward. If there are less values in the
list than there are rows the remaining rows are set to the empty
string. If there are more values in the list than there are rows the
superfluous elements are ignored. The matrix is not extended by this
operation.
.TP
\fImatrixName\fR \fBset rect\fR \fIcolumn row values\fR
Takes a list of lists of cell values and writes them into the
submatrix whose top-left cell is specified by the two indices. If the
sublists of the outerlist are not of equal length the shorter sublists
will be filled with empty strings to the length of the longest
sublist. If the submatrix specified by the top-left cell and the
number of rows and columns in the \fIvalues\fR extends beyond the
matrix we are modifying the over-extending parts of the values are
ignored, i.e. essentially cut off. This subcommand expects its input
in the format as returned by \fBgetrect\fR.
.TP
\fImatrixName\fR \fBset row\fR \fIrow values\fR
Sets the values in the cells identified by the row index to the
elements of the list provided as the third argument. Each element of
the list is assigned to one cell, with the first element going into
the cell in column 0 and then upward. If there are less values in the
list than there are columns the remaining columns are set to the empty
string. If there are more values in the list than there are columns
the superfluous elements are ignored. The matrix is not extended by
this operation.
.TP
\fImatrixName\fR \fBsort columns\fR ?\fB-increasing\fR|\fB-decreasing\fR? \fIrow\fR
Sorts the columns in the matrix using the data in the specified
\fIrow\fR as the key to sort by. The options \fB-increasing\fR
and \fB-decreasing\fR have the same meaning as for \fBlsort\fR.
If no option is specified \fB-increasing\fR is assumed.
.TP
\fImatrixName\fR \fBsort rows\fR ?\fB-increasing\fR|\fB-decreasing\fR? \fIcolumn\fR
Sorts the rows in the matrix using the data in the specified
\fIcolumn\fR as the key to sort by. The options \fB-increasing\fR
and \fB-decreasing\fR have the same meaning as for \fBlsort\fR.
If no option is specified \fB-increasing\fR is assumed.
.TP
\fImatrixName\fR \fBswap columns\fR \fIcolumn_a column_b\fR
Swaps the contents of the two specified columns.
.TP
\fImatrixName\fR \fBswap rows\fR \fIrow_a row_b\fR
Swaps the contents of the two specified rows.
.TP
\fImatrixName\fR \fBtranspose\fR
Transposes the contents of the matrix, i.e. swaps rows for columns and
vice versa.
.TP
\fImatrixName\fR \fBunlink\fR \fIarrayvar\fR
Removes the link between the matrix and the specified arrayvariable,
if there is one.
.PP
.SH EXAMPLES
.PP
The examples below assume a 5x5 matrix M with the first row containing
the values 1 to 5, with 1 in the top-left cell. Each other row
contains the contents of the row above it, rotated by one cell to the
right.
.PP
.nf

 % M getrect 0 0 4 4
 {{1 2 3 4 5} {5 1 2 3 4} {4 5 1 2 3} {3 4 5 1 2} {2 3 4 5 1}}

.fi
.PP
.nf

 % M setrect 1 1 {{0 0 0} {0 0 0} {0 0 0}}
 % M getrect 0 0 4 4
 {{1 2 3 4 5} {5 0 0 0 4} {4 0 0 0 3} {3 0 0 0 2} {2 3 4 5 1}}

.fi
.PP
Assuming that the style definitions in the example section of the
manpage for the package \fBreport\fR are loaded into the
interpreter now an example which formats a matrix into a tabular
report. The code filling the matrix with data is not shown.  contains
useful data.
.PP
.nf

    % ::struct::matrix m
    % # ... fill m with data, assume 5 columns
    % ::report::report r 5 style captionedtable 1
    % m format 2string r
    +---+-------------------+-------+-------+--------+
    |000|VERSIONS:          |2:8.4a3|1:8.4a3|1:8.4a3%|
    +---+-------------------+-------+-------+--------+
    |001|CATCH return ok    |7      |13     |53.85   |
    |002|CATCH return error |68     |91     |74.73   |
    |003|CATCH no catch used|7      |14     |50.00   |
    |004|IF if true numeric |12     |33     |36.36   |
    |005|IF elseif          |15     |47     |31.91   |
    |   |true numeric       |       |       |        |
    +---+-------------------+-------+-------+--------+
    %
    % # alternate way of doing the above
    % r printmatrix m

.fi
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems.
Please report such in the category \fIstruct :: matrix\fR of the
\fITcllib SF Trackers\fR [http://sourceforge.net/tracker/?group_id=12883].
Please also report any ideas for enhancements you may have for either
package and/or documentation.
.SH KEYWORDS
matrix
.SH CATEGORY
Data structures
.SH COPYRIGHT
.nf
Copyright (c) 2002 Andreas Kupries <andreas_kupries@users.sourceforge.net>

.fi