#!/bin/bash
#
# use this script to run several rappture examples:
#
#	./demo.bash
#		
#        ./demo.bash all
#
# when you exit from one example, the next one will start and display on your
# screen.
#

ZOO="\
	./zoo/binary
	./zoo/boolean
	./zoo/choice
	./zoo/curve
	./zoo/drawing
	./zoo/enable
	./zoo/field
	./zoo/group
	./zoo/histogram
	./zoo/image
	./zoo/integer
	./zoo/integer2
	./zoo/loader
	./zoo/log
	./zoo/mesh
	./zoo/note
	./zoo/number
	./zoo/number2
	./zoo/parallelepiped
	./zoo/periodicelement
	./zoo/phase
	./zoo/sequence
	./zoo/string
	./zoo/structure
	./zoo/table
"

FLOW=" \
	./flow/demo1
	./flow/demo2
	./flow/demo3
	./flow
"
FERMI=" \
	./app-fermi/cee
	./app-fermi/fortran
	./app-fermi/tcl
	./app-fermi/perl
	./app-fermi/python
	./app-fermi/ruby
	./app-fermi/java
	./app-fermi/R
	./app-fermi/matlab/uncompiled
	./app-fermi/matlab/compiled
	./app-fermi/octave/octave2
	./app-fermi/octave/octave3
	./app-fermi/wrapper/cee
	./app-fermi/wrapper/tcl
	./app-fermi/wrapper/perl
	./app-fermi/wrapper/python
"

MISC=" \
  ./lang/tcl/putfile \
  ./lang/tcl/loadercopy \
  ./graph \
  ./c-example \
  ./canvas \
  ./objects/xmlparser \
"

ALL="$FERMI $ZOO $FLOW $MISC"

STD="\
  app-fermi/tcl  \
  app-fermi/python  \
  app-fermi/fortran  \
  c-example  \
  graph  \
  zoo/structure  \
  zoo/image  \
  zoo/field \
"
dirs=$STD

if test "$1" = "all" ; then 
  dirs=$ALL
elif test "$1" = "fermi" ; then 
  dirs=$FERMI
elif test "$1" = "flow" ; then 
  dirs=$FLOW
elif test "$1" = "misc" ; then 
  dirs=$MISC
elif test "$1" = "zoo" ; then 
  dirs=$ZOO
fi

for d in $dirs ; do
    echo $d
    (cd $d ; rappture)
done

(cd 3D; rerun 3d_test_run.xml)
