[manpage_begin uri n 1.2]
[moddesc   {Tcl Uniform Resource Identifier Management}]
[titledesc {URI utilities}]
[require Tcl 8.2]
[require uri [opt 1.2]]
[description]

This package contains two parts. First it provides regular expressions
for a number of url/uri schemes. Second it provides a number of
commands for manipulating urls/uris and fetching data specified by
them. For the latter this package analyses the requested url/uri and
then dispatches it to the appropriate package (http, ftp, ...) for
actual fetching.

[para]

The package currently does not conform to
RFC 2396 ([uri http://www.rfc-editor.org/rfc/rfc2396.txt]),
but quite likely should be. Patches and other help are welcome.



[section COMMANDS]

[list_begin definitions]

[call [cmd uri::split] [arg url] [opt [arg defaultscheme]]]

[cmd uri::split] takes an [arg url], decodes it and then returns a
list of key/value pairs suitable for [cmd "array set"] containing the
constituents of the [arg url]. If the scheme is missing from the url
it defaults to the value of [arg defaultscheme] if it was specified,
or [term http] else. Currently only the schemes [term http],

[term ftp], [term mailto], [term urn], [term news], [term ldap] and
[term file] are supported by the package itself.

See section [sectref EXTENDING] on how to expand that range.

[nl]

The set of constituents of an url (= the set of keys in the returned
dictionary) is dependent on the scheme of the url. The only key which
is therefore always present is [const scheme]. For the following
schemes the constituents and their keys are known:

[list_begin definitions]
[lst_item ftp]
[const user], [const pwd], [const host], [const port],
[const path], [const type]

[lst_item http(s)]
[const user], [const pwd], [const host], [const port],
[const path], [const query], [const fragment]. The fragment
is optional.

[lst_item file]
[const path], [const host]. The host is optional.

[lst_item mailto]
[const user], [const host]. The host is optional.

[lst_item news]
Either [const message-id] or [const newsgroup-name].

[list_end]
[nl]


[call [cmd uri::join] [opt "[arg key] [arg value]"]...]

[cmd uri::join] takes a list of key/value pairs (generated by

[cmd uri::split], for example) and returns the canonical url they
represent. Currently only the schemes [term http], [term ftp],
[term mailto], [term urn], [term news], [term ldap] and [term file]
are supported. See section [sectref EXTENDING] on how to expand that
range.


[call [cmd uri::resolve] [arg base] [arg url]]

[cmd uri::resolve] resolves the specified [arg url] relative to

[arg base]. In other words: A non-relative [arg url] is returned
unchanged, whereas for a relative [arg url] the missing parts are
taken from [arg base] and prepended to it. The result of this
operation is returned. For an empty [arg url] the result is

[arg base].


[call [cmd uri::isrelative] [arg url]]

[cmd uri::isrelative] determines whether the specified [arg url] is
absolute or relative.


[call [cmd uri::geturl] [arg url] [opt "[arg options]..."]]

[cmd uri::geturl] decodes the specified [arg url] and then dispatches
the request to the package appropriate for the scheme found in the
url. The command assumes that the package to handle the given scheme
either has the same name as the scheme itself (including possible
capitalization) followed by [cmd ::geturl], or, in case of this
failing, has the same name as the scheme itself (including possible
capitalization). It further assumes that whatever package was loaded
provides a [cmd geturl]-command in the namespace of the same name as
the package itself. This command is called with the given [arg url]
and all given [arg options]. Currently [cmd geturl] does not handle
any options itself.

[nl]

[emph Note:] [term file]-urls are an exception to the rule
described above. They are handled internally.

[nl]

It is not possible to specify results of the command. They depend on
the [cmd geturl]-command for the scheme the request was dispatched to.


[call [cmd uri::canonicalize] [arg uri]]

[cmd uri::canonicalize] returns the canonical form of a URI.  The
canonical form of a URI is one where relative path specifications,
ie. . and .., have been resolved.


[call [cmd uri::register] [arg schemeList] [arg script]]

[cmd uri::register] registers the first element of [arg schemeList] as
a new scheme and the remaining elements as aliases for this scheme. It
creates the namespace for the scheme and executes the [arg script] in
the new namespace. The script has to declare variables containing the
regular expressions relevant to the scheme. At least the variable
[var schemepart] has to be declared as that one is used to extend
the variables keeping track of the registered schemes.

[list_end]

[section  SCHEMES]

In addition to the commands mentioned above this package provides
regular expression to recognize urls for a number of url schemes.

[para]

For each supported scheme a namespace of the same name as the scheme
itself is provided inside of the namespace [emph uri] containing the
variable [var url] whose contents are a regular expression to
recognize urls of that scheme. Additional variables may contain
regular expressions for parts of urls for that scheme.

[para]

The variable [var uri::schemes] contains a list of all supported
schemes. Currently these are [term ftp], [term ldap], [term file],

[term http], [term gopher], [term mailto], [term news],
[term wais] and [term prospero].

[section  EXTENDING]

Extending the range of schemes supported by [cmd uri::split] and

[cmd uri::join] is easy because both commands do not handle the
request by themselves but dispatch it to another command in the
[emph uri] namespace using the scheme of the url as criterion.

[para]

[cmd uri::split] and [cmd uri::join]

call [cmd "Split[lb]string totitle <scheme>[rb]"]
and  [cmd "Join[lb]string totitle <scheme>[rb]"] respectively.

[section  CREDITS]
[para]

Original code (regular expressions) by Andreas Kupries.
Modularisation by Steve Ball, also the split/join/resolve
functionality.

[keywords uri url {fetching information} www http ftp mailto]
[keywords news gopher wais ldap prospero file]
[keywords {rfc 2396} {rfc 2255}]
[manpage_end]
