#!/bin/sh

# Fail script on error.
set -e

host_os=`uname -s`
echo $system

#base_dir=/apps/rappture
base_dir=`pwd`/builds
build_dir=$base_dir/`date +%Y%m%d`
mkdir -p $build_dir

stage1_flags="\
 --without-cmake \
 --with-expat \
 --with-zlib \
 --without-tcl \
 --without-tk \
"
stage2_flags=" \
 --without-blt \
 --without-htmlwidget \
 --without-shape \
 --without-tcllib \
 --without-tDOM \
 --without-tkimg \
 --without-tls \
 --without-voronoi \
 --without-itcl \
"
rappture_flags=" \
 --disable-gui \
 --without-tclsh \
 --without-matlab \
 --without-octave \
 --without-perl \
 --without-python \
 --without-ruby \
"

MAKE=make
case $host_os in
   *Darwin* )
      DYLD_LIBRARY_PATH=$build_dir/lib
      export DYLD_LIBRARY_PATH
      ;;
   *Linux*  )
      LD_LIBRARY_PATH=$build_dir/lib
      export LD_LIBRARY_PATH
      ;;
   *FreeBSD* )
      MAKE=gmake
      LD_LIBRARY_PATH=$build_dir/lib
      export LD_LIBRARY_PATH
      ;;
esac

PATH=/usr/local/bin:/usr/bin:/bin:/usr/X11R6/bin:/usr/X11/bin:/usr/openwin/bin:$PATH:$build_dir/bin

export MAKE PATH

stage1() {
    pwd=`pwd`
    if test -d "stage1" ; then
      cd stage1
    else
      mkdir -p stage1
      cd stage1
      ../runtime/configure --prefix=$build_dir --exec_prefix=$build_dir \
       $stage1_flags
    fi
    ${MAKE} all
    ${MAKE} install
    cd $pwd
}

stage2() {
    pwd=`pwd`
    if test -d "stage2" ; then
      cd stage2
    else
      mkdir -p stage2
      cd stage2
      ../runtime/configure --prefix=$build_dir --exec_prefix=$build_dir \
       $stage2_flags
    fi
    ${MAKE} all
    ${MAKE} install
    cd $pwd
}

rappture() {
    pwd=`pwd`
    if test -d "stage.rappture" ; then
      cd stage.rappture
    else
      mkdir -p stage.rappture
      cd stage.rappture
      ../rappture/configure --prefix=$build_dir --exec_prefix=$build_dir \
       $rappture_flags
    fi
    ${MAKE} all
    ${MAKE} install
    cd $pwd
}

stage1
stage2
rappture

exit 0
