#!/bin/sh

# usage: dpkg <destdir> <version>
# (e.g. dpkg /tmp/install 20100404)

# Previously generate directories from svn
#
# svn co https://repo.nanohub.org/svn/rappture-bat/trunk/buildscripts bat
# svn co https://repo.nanohub.org/svn/rappture/trunk rappture
# svn co https://repo.nanohub.org/svn/rappture-runtime/trunk runtime
# 
# the run this script.
#  
#   DESTDIR=<destdir> sh ./dpkg.sh
#
export DESTDIR
# Fail script on error.
set -e

host_os=`uname -s`
echo $system

base_dir=$1/apps/rappture
build_dir=$base_dir/$2
mkdir -p $build_dir
install_dir=/apps/rappture/$2
#
# You can build VTK or use your system's installed version of VTK 
# (if one exists).  If you use the system's version, the version of 
# Tcl/Tk installed on your system must match the version of Tcl/Tk 
# built for Rappture.  If you don't know, just build VTK here.
#
# To build VTK add 
#  "--with-cmake to stage1_flags 
#  "--with-vtk   to stage3_flags 
# 

stage1_flags=""
stage2_flags=""
stage3_flags=""
rappture_flags=""

MAKE=make
case $host_os in 
   *Darwin* )
      DYLD_LIBRARY_PATH=$build_dir/lib
      export DYLD_LIBRARY_PATH
      ;;
   *Linux*  )
      LD_LIBRARY_PATH=$build_dir/lib
      export LD_LIBRARY_PATH
      ;;
   *FreeBSD* )
      MAKE=gmake
      LD_LIBRARY_PATH=$build_dir/lib
      export LD_LIBRARY_PATH
      ;;
esac

PATH=/usr/local/bin:/usr/bin:/bin:/usr/X11R6/bin:/usr/X11/bin:/usr/openwin/bin:$build_dir/bin:$PATH

export MAKE PATH

stage1() {
    pwd=`pwd`
    if test -d "stage1" ; then 
      cd stage1
    else 
      mkdir -p stage1
      cd stage1
      ../runtime/configure --prefix=$build_dir --exec_prefix=$build_dir \
       $stage1_flags
    fi
    ${MAKE} all
    ${MAKE} install
    cd $pwd
}

stage2() {
    pwd=`pwd`
    if test -d "stage2" ; then 
      cd stage2
    else 
      mkdir -p stage2
      cd stage2
      ../runtime/configure --prefix=$build_dir --exec_prefix=$build_dir \
       $stage2_flags
    fi
    ${MAKE} all
    ${MAKE} install
    cd $pwd
}


stage3() {
    pwd=`pwd`
    if test -d "stage3" ; then 
      cd stage3
    else 
      mkdir -p stage3
      cd stage3
      ../runtime/configure --prefix=$build_dir --exec_prefix=$build_dir \
       $stage3_flags
    fi
    ${MAKE} all
    ${MAKE} install
    cd $pwd
}

rappture() {
    pwd=`pwd`
    if test -d "stage.rappture" ; then 
      cd stage.rappture
    else 
      mkdir -p stage.rappture
      cd stage.rappture
      ../rappture/configure --prefix=$build_dir --exec_prefix=$build_dir \
       --with-install=$install_dir $rappture_flags
    fi
    ${MAKE} all
    ${MAKE} install
    cd $pwd
}

stage1
stage2
stage3
rappture

exit 0
