# ----------------------------------------------------------------------
#  EXAMPLE: Rappture <log> elements
# ======================================================================
#  AUTHOR:  Michael McLennan, Purdue University
#  Copyright (c) 2004-2012  HUBzero Foundation, LLC
#
#  See the file "license.terms" for information on usage and
#  redistribution of this file, and for a DISCLAIMER OF ALL WARRANTIES.
# ======================================================================
package require Rappture

# open the XML file containing the run parameters
set driver [Rappture::library [lindex $argv 0]]

$driver put output.log "****** ADEPT/F - 2.1   input file: adp20638      Sat Jul 30 19:39:36 2005 ******

   1 *title  input generated by adeptwr
            
   2 mesh  nx=250 xres=0.5
   3 misc  tempk=300
                
   4 * layer Al(0.3)Ga(0.7)As
   5 layer tm=0.2 nd=1e+17
   6 +     eg=1.797 chi=3.827 ks=11.9
   7 +     nc=8.57e+17 nv=1.11e+19
   8 +     eaa=-1.0 ead=-1.0
   9 +     taun.shr=1.0e-9 taup.shr=1.0e-9 et.shr=0.0
  10 +     un=1000. vsatn=1.0e7 up=100. vsatp=1.0e7

  11 * layer GaAs
  12 layer tm=0.2  na=1e+17
  13 +     eg=1.422 chi=4.070 ks=12.847
  14 +     nc=4.62e+17 nv=9.42e+18
  15 +     eaa=-1.0 ead=-1.0
  16 +     taun.shr=1.0e-9 taup.shr=1.0e-9 et.shr=0.0
  17 +     un=1000. vsatn=1.0e7 up=100. vsatp=1.0e7

  18 solve  itmax=100
  19 output  info=0 step=1




 ******execution time =        0.1 cpu seconds."

# save the updated XML describing the run...
Rappture::result $driver
exit 0
