# @package      hubzero-python
# @file         ldapconfig.py
# @author       David Benham <dbenham@purdue.edu>
# @copyright    Copyright (c) 2012-2015 HUBzero Foundation, LLC.
# @license      http://www.gnu.org/licenses/lgpl-3.0.html LGPLv3
#
# Copyright (c) 2012-2015 HUBzero Foundation, LLC.
#
# This file is part of: The HUBzero(R) Platform for Scientific Collaboration
#
# The HUBzero(R) Platform for Scientific Collaboration (HUBzero) is free
# software: you can redistribute it and/or modify it under the terms of
# the GNU Lesser General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any
# later version.
#
# HUBzero is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# HUBzero is a registered trademark of HUBzero Foundation, LLC.
#

import ConfigParser
import hubzero.config.hubzerositeconfig
import hubzero.utilities.misc
import hubzero.data.db
import re
import os


def getLDAPSiteSuffix():
	rc, procOutput, procErr = hubzero.utilities.misc.exShellCommand(['slapcat', '-b', 'cn=config', '-a', '(objectClass=olcDatabaseConfig)'])
	fullSlapcatOutput = procOutput
	
	# get the olcSuffix
	matchObj = re.search(r'olcSuffix: (.*)$' , fullSlapcatOutput, re.M)
	if matchObj:
		suffix = matchObj.group(1)
	else:
		raise Exception("cannot find olcSuffix")

	return suffix
