# @package      hubzero-python
# @file         passwords.py
# @author       David Benham <dbenham@purdue.edu>
# @copyright    Copyright (c) 2012-2014 HUBzero Foundation, LLC.
# @license      http://www.gnu.org/licenses/lgpl-3.0.html LGPLv3
#
# Copyright (c) 2012-2014 HUBzero Foundation, LLC.
#
# This file is part of: The HUBzero(R) Platform for Scientific Collaboration
#
# The HUBzero(R) Platform for Scientific Collaboration (HUBzero) is free
# software: you can redistribute it and/or modify it under the terms of
# the GNU Lesser General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any
# later version.
#
# HUBzero is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# HUBzero is a registered trademark of HUBzero Foundation, LLC.
#

import base64
import re
import hashlib
import hubzero.config
import random
import string

secretsFileLocation = "/etc/hubzero.secrets"

def _getSecretsConfigOption(optionName):
	# read config values from file
	file = open(secretsFileLocation)
	fileContents = file.read()
	
	# grep for right line
	m = re.search("^\s*" + optionName + "\s*=\s*(.*)$", fileContents, re.MULTILINE)

	# return whatever we find, if not found, this will be none type
	if m:
		return m.group(1).rstrip()
	else:
		return ""

def generateAlphaNumPassword(length):
	pw = ''.join(random.choice(string.ascii_uppercase + string.ascii_lowercase + string.digits) for x in range(length))	
	return pw		    

		    
def getMySqlPW():
	return _getSecretsConfigOption("MYSQL-ROOT")


def MD5PasswordHash(pw):
	return "{MD5}" + base64.b64encode(hashlib.md5(str(pw)).digest())
