# @package      hubzero-python
# @file         user.py
# @author       David Benham <dbenham@purdue.edu>
# @copyright    Copyright (c) 2012 HUBzero Foundation, LLC.
# @license      http://www.gnu.org/licenses/lgpl-3.0.html LGPLv3
#
# Copyright (c) 2012 HUBzero Foundation, LLC.
#
# This file is part of: The HUBzero(R) Platform for Scientific Collaboration
#
# The HUBzero(R) Platform for Scientific Collaboration (HUBzero) is free
# software: you can redistribute it and/or modify it under the terms of
# the GNU Lesser General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any
# later version.
#
# HUBzero is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# HUBzero is a registered trademark of HUBzero Foundation, LLC.
#

import datetime
import hubzero.config.passwords
import hubzero.data.db
import ldap
import ldap.modlist


def _del_jos_users(db, username):
	sql = 'select id from `jos_users` where username = %s'
	data = (username)
	userID = db.execSelectQueryScalar(sql, data)	

	sql = 'delete from `jos_users` where userid = %s'
	data = (userid)
	userID = db.execSelectQueryScalar(sql, data)	

	return userID


def _del_jos_core_acl_aro(db, userID):

	sql = 'select id from `jos_core_acl_aro` where value = %s'
	data = (userID)
	aroID = db.execSelectQueryScalar(sql, data)	

	sql = "DELETE FROM `jos_core_acl_aro` where `value` = %s  "
	data = (userID)
	db.execQuery(sql, data)
	
	return aroID

def _del_jos_core_acl_groups_aro_map(db, aroID):
	sql = "DELETE FROM `jos_core_acl_groups_aro_map` WHERE `aro_id` = %s"
	data = (aroID)
	db.execQuery(sql, data)


def _del_jos_xprofiles(db, uidNumber):
	sql = "DELETE FROM `jos_xprofiles` WHERE `uidNumber` = %s"
	data = (uidNumber)
	db.execQuery(sql, data)


def _insert_jos_users(db, joomlauserid, name, username, email, pw, jgid, jgidNumber):

	pwhash = hubzero.config.passwords.MD5PasswordHash(pw)

	if joomlauserid == -1:
		sql = "INSERT INTO `jos_users` (`name`, `username`, `email`, `password`, `usertype`, `block`, `sendEmail`, `gid`, `registerDate`, `lastvisitDate`, `activation`, `params`)"
		sql += "VALUES (%s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s);"
		data = (name, username, email, pwhash , jgid, 0, 1, jgidNumber, datetime.datetime.now(), '0000-00-00 00:00:00', '', '');
		userID = db.execInsertQuery(sql, data)
	else:
		sql = "INSERT INTO `jos_users` (`id`, `name`, `username`, `email`, `password`, `usertype`, `block`, `sendEmail`, `gid`, `registerDate`, `lastvisitDate`, `activation`, `params`)"
		sql += "VALUES (%s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s);"
		data = (joomlauserid, name, username, email, pwhash, jgid, 0, 1, jgidNumber, datetime.datetime.now(), '0000-00-00 00:00:00', '', '');
		userID = db.execInsertQuery(sql, data)

	return userID


def _insert_jos_core_acl_aro(db, userID, fullname):
	sql = "INSERT INTO `jos_core_acl_aro` (`section_value`, `value`, `order_value`, `name`, `hidden`) "
	sql += "VALUES (%s, %s, %s, %s, %s)"
	data = ( 'users',  userID, 0, fullname, 0)
	aroID = db.execInsertQuery(sql, data)
	return aroID
	

def _insert_jos_core_acl_groups_aro_map(db, jgidNumber, aroID):
	sql = "INSERT INTO `jos_core_acl_groups_aro_map` (`group_id`, `section_value`, `aro_id`) "
	sql += "VALUES (%s, %s, %s)"
	data = ( jgidNumber, '', aroID)
	db.execQuery(sql, data)


def _insert_jos_xprofiles(db, uid, fname, lname, username, email, joomlagid, joomlagidNumber, gid, gidNumber):
	sql = "INSERT INTO `jos_xprofiles` (`uidNumber`, `name`, `username`, `email`, `registerDate`, `gidNumber`, `homeDirectory`, `loginShell`, "
	sql += "`ftpShell`, `userPassword`, `gid`, `orgtype`, `organization`, `countryresident`, `countryorigin`, `gender`, `url`, `reason`, "
	sql += "`mailPreferenceOption`, `usageAgreement`, `jobsAllowed`, `modifiedDate`, `emailConfirmed`, `regIP`, `regHost`, `nativeTribe`, `phone`, "
	sql += "`proxyPassword`, `proxyUidNumber`, `givenName`, `middleName`, `surname`, `picture`, `vip`, `public`, `params`, `note`, `shadowExpire`) "
	sql += "VALUES (" + '%s,'*37 + "%s );" 
	
	data = (uid, fname + ' ' + lname, username, email, datetime.datetime.now(), gidNumber, '/home/username', '', 
	        '', 'password', gid, 'public', '', '', '', '', '', '', 
	        0, 0, 3, '0000-00-00 00:00:00', 1, '', '', '', '',
	        '', '', fname, '', lname, '', 0, 0, '', '', None)
	db.execQuery(sql, data)


def _insert_jos_xgroups(db, name, description):
	"""	
	cn                             | varchar(255) | YES  | 
	description                    | varchar(255) | YES  | 
	published                      | tinyint(3)   | YES  | 
	type                           | tinyint(3)   | YES  | 
	access                         | tinyint(3)   | YES  | 
	public_desc                    | text         | YES  | 
	private_desc                   | text         | YES  | 
	restrict_msg                   | text         | YES  | 
	join_policy                    | tinyint(3)   | YES  | 
	privacy                        | tinyint(3)   | YES  | 
	discussion_email_autosubscribe | tinyint(3)   | YES  | 
	logo                           | varchar(255) | YES  | 
	overview_type                  | int(11)      | YES  | 
	overview_content               | text         | YES  | 
	plugins                        | text         | YES  | 
	created                        | datetime     | YES  | 
	created_by                     | int(11)      | YES  | 
	params                         | text 	
	"""
	sql =  "INSERT INTO jos_xgroups ( `cn`, `description`, `published`, `type`, `access`, `public_desc`, `private_desc`, `restrict_msg`, "
	sql += "`join_policy`, `privacy`, `discussion_email_autosubscribe`, `logo`, `overview_type`, `overview_content`, `plugins`, `created`,"
	sql += "`created_by`, `params`) " 
	sql += "VALUES (" + '%s,'*17 + "%s );" 

	data = (name, description, 0, 1, 0, '', '', '',   1, 1, 0, '', None, None, None, datetime.datetime.now(), None, None)
	gidNumber = db.execInsertQuery(sql, data)
	return gidNumber


def _del_jos_xgroups(db, name):
	sql = "DELETE FROM jos_xgroups WHERE `CN`=%s "
	data = (name)
	db.execQuery(sql, data)


def _add_ldap_group(groupName, groupDescription, gidNumber):
	hubLDAPAcctMgrPW = hubzero.config.webconfig.getWebConfigOption("hubLDAPAcctMgrPW")	
	hubLDAPAcctMgrDN = hubzero.config.webconfig.getWebConfigOption("hubLDAPAcctMgrDN")	
	hubLDAPBaseDN = hubzero.config.webconfig.getWebConfigOption("hubLDAPBaseDN")

	l = ldap.open("localhost")
	l.simple_bind_s(hubLDAPAcctMgrDN, hubLDAPAcctMgrPW)
	
	dn = "cn=" + groupName + ",ou=groups," + hubLDAPBaseDN
	attrs = {}
	attrs['objectclass'] = ['posixGroup', 'top']
	attrs['cn'] = groupName
	attrs['gidNumber'] =str( gidNumber)
	attrs['description'] = groupDescription
	#attrs['ou'] = 'users'
	ldif = ldap.modlist.addModlist(attrs)
	print ldif
	l.add_s(dn, ldif)


def _del_ldap_group(groupName):
	# get ldapManagerUserDN and PW
	hubLDAPAcctMgrPW = hubzero.config.webconfig.getWebConfigOption("hubLDAPAcctMgrPW")	
	hubLDAPAcctMgrDN = hubzero.config.webconfig.getWebConfigOption("hubLDAPAcctMgrDN")	
	hubLDAPBaseDN = hubzero.config.webconfig.getWebConfigOption("hubLDAPBaseDN")

	l = ldap.open("localhost")
	l.simple_bind_s(hubLDAPAcctMgrDN, hubLDAPAcctMgrPW)

	dn = "cn=" + groupName + ",ou=groups," + hubLDAPBaseDN
	print dn
	l.delete_s(dn)



def _add_ldap_user(username, password):

	# get ldapManagerUserDN and PW
	hubLDAPAcctMgrPW = hubzero.config.webconfig.getWebConfigOption("hubLDAPAcctMgrPW")	
	hubLDAPAcctMgrDN = hubzero.config.webconfig.getWebConfigOption("hubLDAPAcctMgrDN")	
	hubLDAPBaseDN = hubzero.config.webconfig.getWebConfigOption("hubLDAPBaseDN")

	l = ldap.open("localhost")
	l.simple_bind_s(hubLDAPAcctMgrDN, hubLDAPAcctMgrPW)

	dn = "cn=" + username + "," + hubLDAPBaseDN
	attrs = {}
	attrs['objectclass'] = ['organizationalRole', 'simpleSecurityObject']
	attrs['cn'] = username
	attrs['userPassword'] = "none"
	attrs['uid'] = username
	ldif = ldap.modlist.addModlist(attrs)
	l.add_s(dn, ldif)


def _delete_ldap_user(username):
	# get ldapManagerUserDN and PW
	hubLDAPAcctMgrPW = hubzero.config.webconfig.getWebConfigOption("hubLDAPAcctMgrPW")	
	hubLDAPAcctMgrDN = hubzero.config.webconfig.getWebConfigOption("hubLDAPAcctMgrDN")	
	hubLDAPBaseDN = hubzero.config.webconfig.getWebConfigOption("hubLDAPBaseDN")

	l = ldap.open("localhost")
	l.simple_bind_s(hubLDAPAcctMgrDN, hubLDAPAcctMgrPW)

	dn = "cn=" + username + "," + hubLDAPBaseDN
	l.delete_s(dn)


def delhubgroup(groupName):
	# grab config options
	dbPW = hubzero.config.passwords.getMySqlPW()
	db =  hubzero.data.db.mySql("localhost", "myhub", "myhub", dbPW)
	_del_ldap_group(groupName)
	_del_jos_xgroups(db, groupName)


def addhubgroup(groupName):
	# grab config options
	dbPW = hubzero.config.passwords.getMySqlPW()
	db =  hubzero.data.db.mySql("localhost", "myhub", dbPW, "myhub")
	
	gidNumber = _insert_jos_xgroups(db, groupName, groupName)
	
	print "gidNumber = " + str(gidNumber)
	
	_add_ldap_group(groupName, groupName, gidNumber)
	
	
def addhubuser(username, fname, lname, email, pw, joomlagid, joomlagidNumber, gid, gidNumber, joomlauserid, skipldap):
	# grab config options
	dbPW = hubzero.config.webconfig.getWebConfigDBPassword()
	dbUserName = hubzero.config.webconfig.getWebConfigDBUsername()
	dbName = hubzero.config.webconfig.getWebConfigDBName()
	
	db =  hubzero.data.db.mySql("localhost", dbName, dbUserName, dbPW)
	
	fullname = fname + ' ' + lname

	userID = _insert_jos_users(db, joomlauserid, fullname, username, email, pw, joomlagid, joomlagidNumber)
	aroID = _insert_jos_core_acl_aro(db, userID, fullname)
	_insert_jos_core_acl_groups_aro_map(db, joomlagidNumber, aroID)
	_insert_jos_xprofiles(db, userID, fname, lname, username, email, joomlagid, joomlagidNumber, gid, gidNumber)
	
	if not skipldap:
		_add_ldap_user(username, 'nopasswd')

	
def delhubuser(username):
	# grab config options
	dbPW = hubzero.config.passwords.getMySqlPW()
	db =  hubzero.data.db.mySql("localhost", "myhub", "myhub", dbPW)
	
	sql = 'select id from `jos_users` where username = %s'
	data = (username)
	userID = db.execSelectQueryScalar(sql, data)
	aroID = _del_jos_core_acl_aro(db, userID)
	_del_jos_core_acl_groups_aro_map(db, aroID)
	_del_jos_xprofiles(db, userID)	
	_delete_ldap_user(username)
	
	
				  
                  
