# @package      hubzero-python
# @file         hubzerositeconfig.py
# @author       David Benham <dbenham@purdue.edu>
# @copyright    Copyright (c) 2012 HUBzero Foundation, LLC.
# @license      http://www.gnu.org/licenses/lgpl-3.0.html LGPLv3
#
# Copyright (c) 2012 HUBzero Foundation, LLC.
#
# This file is part of: The HUBzero(R) Platform for Scientific Collaboration
#
# The HUBzero(R) Platform for Scientific Collaboration (HUBzero) is free
# software: you can redistribute it and/or modify it under the terms of
# the GNU Lesser General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any
# later version.
#
# HUBzero is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# HUBzero is a registered trademark of HUBzero Foundation, LLC.
#

import ConfigParser
import os

hubzeroConfFileLocation = "/etc/hubzero.conf"

def getHubzeroConfigOption(headerName, optionName):

	if not os.path.exists(hubzeroConfFileLocation):
		raise Exception("Cannot find hubzeroConfFileLocation:" + hubzeroConfFileLocation)

	config = ConfigParser.ConfigParser()
	config.readfp(open(hubzeroConfFileLocation))

	return config.get(headerName, optionName)
	

def getHubDefaultSite():
	return getHubzeroConfigOption("default", "site")
