import MySQLdb

class mySql:

	db = None
	dbHost = ""
	dbName = ""
	dbPW = ""
	dbUsername = ""

	def _db_connect(self):
		self.db = MySQLdb.connect(host=self.dbHost, 
		                          user=self.dbUsername, 
		                          passwd=self.dbPW, 
		                          db=self.dbName)


	def __init__(self, _dbHost, _dbName, _dbPW, _dbUsername):
		self.dbHost = _dbHost
		self.dbName = _dbName
		self.dbPW = _dbPW
		self.dbUsername = _dbUsername
		self._db_connect()

	
	def execInsertQuery(self, sql, data):
		"""
		Insert query that returns the pkid of the last inserted row
		"""
		cursor = self.db.cursor()
		cursor.execute(sql, data)
		newID = cursor.lastrowid
		cursor.close()
		return newID

		
	def execQuery(self, sql, data):
		"""
		Generic query executor
		"""
		cursor = self.db.cursor()
		cursor.execute(sql, data)
		cursor.close()


	def execSelectQuery(self, sql, data):
		"""
		Return results in list of lists for caller
		"""
		cursor = self.db.cursor()
		cursor.execute(sql, data)
		results = cursor.fetchall()	
		cursor.close()
		return results
	
	
	def execSelectQueryScalar(self, sql, data):
		"""
		When you're looking for an easy way to get only a single value from a query returned
		"""
		results = self.execSelectQuery(sql, data)
		if len(results) == 0:
			raise Exception('empty result set returned, size = ' + str(len(results)))
		elif len(results) != 1:
			raise Exception('non scalar result set returned, size = ' + str(len(results)))
		else:	
			return results[0][0]
	