import hubzero.config.hubzerositeconfig
import re
import os

def getWebConfigOption(optionName):
	
	# get the locaiton of the web config file
	defaultSite = hubzero.config.hubzerositeconfig.getHubzeroConfigOption("default", "site")
	wwwDocRoot = hubzero.config.hubzerositeconfig.getHubzeroConfigOption(defaultSite, "DocumentRoot")	
	
	# read config values from file
	file = open(wwwDocRoot + "/configuration.php")
	configValues = file.read()
	file.close()
	
	# hubconfig might still be around, if so, dump this file into our search string... we're gonna assume no variable
	
	if os.path.exists(wwwDocRoot + "/hubconfiguration.php"):
		file = open(wwwDocRoot + "/hubconfiguration.php")
		hubconfigFileContents = file.read()
		file.close()
		configValues += hubconfigFileContents
	
	# grep for right line
	regEx = "var\s*\$" + optionName + "\s*=\s*'(.*)';"
	m = re.search(regEx, configValues, re.MULTILINE | re.IGNORECASE)

	#print regEx
	#print configValues

	# return whatever we find, if not found, this will be none type
	if m:
		return m.group(1)
	else:
		return ""
		    
