import re
import hashlib

secretsFileLocation = "/etc/hubzero.secrets"

def _getSecretsConfigOption(optionName):
	# read config values from file
	file = open(secretsFileLocation)
	fileContents = file.read()
	
	# grep for right line
	m = re.search("^" + optionName + "=(.*)$", fileContents, re.MULTILINE)

	# return whatever we find, if not found, this will be none type
	if m:
		return m.group(1)
	else:
		return ""
		    
def getMySqlPW():
	return _getSecretsConfigOption("MYSQL-ROOT")


def MD5PasswordHash(pw):
	return "{MD5}" + base64.encodestring(hashlib.md5(str(ldapPW)).digest())
	
