import datetime
import hubzero.config.passwords
import hubzero.data.db
import ldap
import ldap.modlist

def _insert_jos_users(db, name, username, email, jgid, jgidNumber, ):
	
	sql = "INSERT INTO `jos_users` (`name`, `username`, `email`, `password`, `usertype`, `block`, `sendEmail`, `gid`, `registerDate`, `lastvisitDate`, `activation`, `params`)"
	sql += "VALUES (%s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s);"
	data = (name, username, email, 'NOPASSWORD', jgid, 0, 1, jgidNumber, datetime.datetime.now(), '0000-00-00 00:00:00', '', '');
	userID = db.execInsertQuery(sql, data)
	return userID

def _insert_jos_core_acl_aro(db, userID, fullname):
	sql = "INSERT INTO `jos_core_acl_aro` (`section_value`, `value`, `order_value`, `name`, `hidden`) "
	sql += "VALUES (%s, %s, %s, %s, %s)"
	data = ( 'users',  userID, 0, fullname, 0)
	aroID = db.execInsertQuery(sql, data)
	return aroID
	# INSERT INTO `#__core_acl_aro` (`id`, `section_value`, `value`, `order_value`, `name`, `hidden`) VALUES (1,'users','62',0,'Administrator',0);
	
def _insert_jos_core_acl_groups_aro_map(db, jgidNumber, aroID):
	sql = "INSERT INTO `jos_core_acl_groups_aro_map` (`group_id`, `section_value`, `aro_id`) "
	sql += "VALUES (%s, %s, %s)"
	data = ( jgidNumber, '', aroID)
	db.execQuery(sql, data)
	# INSERT INTO `#__core_acl_groups_aro_map` (`group_id`, `section_value`, `aro_id`) VALUES (25,'',10);

def _insert_jos_xprofiles(db, uid, fname, lname, username, email, joomlagid, joomlagidNumber, gid, gidNumber):
	sql = "INSERT INTO `jos_xprofiles` (`uidNumber`, `name`, `username`, `email`, `registerDate`, `gidNumber`, `homeDirectory`, `loginShell`, "
	sql += "`ftpShell`, `userPassword`, `gid`, `orgtype`, `organization`, `countryresident`, `countryorigin`, `gender`, `url`, `reason`, "
	sql += "`mailPreferenceOption`, `usageAgreement`, `jobsAllowed`, `modifiedDate`, `emailConfirmed`, `regIP`, `regHost`, `nativeTribe`, `phone`, "
	sql += "`proxyPassword`, `proxyUidNumber`, `givenName`, `middleName`, `surname`, `picture`, `vip`, `public`, `params`, `note`, `shadowExpire`) "
	sql += "VALUES (" + '%s,'*37 + "%s );" 
	
	data = (uid, fname + ' ' + lname, username, email, datetime.datetime.now(), gidNumber, '/home/username', '', 
	        '', 'password', gid, 'public', '', '', '', '', '', '', 
	        0, 0, 3, '0000-00-00 00:00:00', 1, '', '', '', '',
	        '', '', fname, '', lname, '', 0, 0, '', '', None)
	db.execQuery(sql, data)
	
	#VALUES 
	#(62,'Administrator','admin','root@localhost',NOW(),'3000','/home/admin','',
	#'','NOPASSWORD','public','','','','','','',''
	#,0,0,3,'0000-00-00 00:00:00',1,'','','','',
	#'','','Administrator','','','',0,0,'','',NULL);

def _add_ldap_user(username, password):

	# get ldapManagerUserDN and PW
	hubLDAPAcctMgrPW = hubzero.config.webconfig.getWebConfigOption("hubLDAPAcctMgrPW")	
	hubLDAPAcctMgrDN = hubzero.config.webconfig.getWebConfigOption("hubLDAPAcctMgrDN")	
	hubLDAPBaseDN = hubzero.config.webconfig.getWebConfigOption("hubLDAPBaseDN")

	l = ldap.open("localhost")
	l.simple_bind_s(hubLDAPAcctMgrDN, hubLDAPAcctMgrPW)

	dn = "cn=" + username + "," + hubLDAPBaseDN
	attrs = {}
	attrs['objectclass'] = ['organizationalRole', 'simpleSecurityObject']
	attrs['cn'] = username
	attrs['userPassword'] = "none"
	ldif = ldap.modlist.addModlist(attrs)
	l.add_s(dn, ldif)
	
def addhubuser(username, fname, lname, email, joomlagid, joomlagidNumber, gid, gidNumber):
	# grab config options
	dbPW = hubzero.config.passwords.getMySqlPW()
	db =  hubzero.data.db.mySql("localhost", "myhub", dbPW, "myhub")
	
	fullname = fname + ' ' + lname

	userID = _insert_jos_users(db, fullname, username, email, joomlagid, joomlagidNumber)
	aroID = _insert_jos_core_acl_aro(db, userID, fullname)
	_insert_jos_core_acl_groups_aro_map(db, joomlagidNumber, aroID)
	_insert_jos_xprofiles(db, userID, fname, lname, username, email, joomlagid, joomlagidNumber, gid, gidNumber)
	_add_ldap_user(username, 'nopasswd')
	
	
				  
                  