# @package      hubzero-mw2-common
# @file         errors.py
# @copyright    Copyright (c) 2016-2020 The Regents of the University of California.
# @license      http://opensource.org/licenses/MIT MIT
#
# Copyright (c) 2016-2020 The Regents of the University of California.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# HUBzero is a registered trademark of The Regents of the University of California.
#

"""
Define exceptions for the middleware, which can be caught and handled at different levels.
"""

class MaxwellError(StandardError):
  """Base class for exceptions in this module."""
  pass

class ChildError(MaxwellError):
  """So os._exit can be called as appropriate."""
  pass

class PublicError(MaxwellError):
  """An error that is both logged and fully displayed to the user."""
  pass

class PrivateError(MaxwellError):
  """An error whose details are hidden from the user.  Full details are logged."""
  pass

class InputError(MaxwellError):
  """When invalid inputs were provided."""
  pass

class SessionError(MaxwellError):
  """Base class for errors in manipulating sessions."""
  pass

class DisplayError(MaxwellError):
  """Base class for errors in manipulating displays."""
  pass
