/**
 * @package      hubzero-mw-session
 * @file         clientaction/clientaction.c
 * @author       Rick Kennell <kennell@purdue.edu>
 * @copyright    Copyright (c) 2005-2015 HUBzero Foundation, LLC.
 * @license      http://opensource.org/licenses/MIT MIT
 *
 * Copyright (c) 2005-2015 HUBzero Foundation, LLC.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 * HUBzero is a registered trademark of HUBzero Foundation, LLC.
 *
 */

//
// VNC server utility to tell clients to perform an action
//

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include <malloc.h>

#include <signal.h>
#include <X11/X.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>
#include "vncExt.h"

char* programName = 0;
Display* dpy;
int vncExtEventBase, vncExtErrorBase;

int main(int argc, char** argv)
{
  programName = argv[0];

  if (argc < 2) {
    fprintf(stderr,"syntax: %s action to send\n", programName);
    exit(1);
  }

  char *display = getenv("DISPLAY");
  if (display == NULL) {
    fprintf(stderr,"%s: No DISPLAY variable set", programName);
    exit(1);
  }

  if (!(dpy = XOpenDisplay(display))) {
    fprintf(stderr,"%s: unable to open display \"%s\"\n",
            programName, display);
    exit(1);
  }

  if (!XVncExtQueryExtension(dpy, &vncExtEventBase, &vncExtErrorBase)) {
    fprintf(stderr,"No VNC extension on display %s\n", display);
    exit(1);
  }

  // Determine the string length.
  int len=0;
  int i;
  for(i=1; i<argc; i++) {
    if (i > 1)
      len += 1;  // arguments are separated by space
    len += strlen(argv[i]);
  }

  char *str = calloc(1, len + 1);
  for(i=1; i<argc; i++) {
    if (i > 1)
      strcat(str," ");
    strcat(str,argv[i]);
  }

  if (!XVncExtClientAction(dpy, str, len)) {
    fprintf(stderr,"%s: failed\n", programName);
    exit(1);
  }

  XCloseDisplay(dpy);

  return 0;
}
