/**
 * @package      hubzero-mw-session
 * @file         pixelflip/pixelflip.c
 * @author       Rick Kennell <kennell@purdue.edu>
 * @copyright    Copyright (c) 2005-2015 HUBzero Foundation, LLC.
 * @license      http://www.gnu.org/licenses/lgpl-3.0.html LGPLv3
 *
 * Copyright (c) 2005-2015 HUBzero Foundation, LLC.
 *
 * This file is part of: The HUBzero(R) Platform for Scientific Collaboration
 *
 * The HUBzero(R) Platform for Scientific Collaboration (HUBzero) is free
 * software: you can redistribute it and/or modify it under the terms of
 * the GNU Lesser General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any
 * later version.
 *
 * HUBzero is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * HUBzero is a registered trademark of HUBzero Foundation, LLC.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <X11/Xlib.h>

#define SZ 1
#define INTERVAL (5*60) /* five minutes */
//#define INTERVAL (1)

int main(int argc, char *argv[])
{
  Display *d;
  int s;
  int root;
  int w;
  XSetWindowAttributes attrs;
  int mask;
  GC gc1, gc2;
  XGCValues gcvals;
  Colormap cmap;
  XColor def;
  int grey;


  d = XOpenDisplay(NULL);
  if (d == NULL) {
    fprintf(stderr,"%s: Can't open display", argv[0]);
    exit(1);
  }

  s = DefaultScreen(d);
  root = RootWindow(d,s);

  attrs.override_redirect = True;
  mask = CWOverrideRedirect;
  w = XCreateWindow(d, root, 0, 0, SZ, SZ, 0, CopyFromParent, InputOutput,
                    CopyFromParent, mask, &attrs);

  gcvals.background = BlackPixel(d,s);
  gcvals.foreground = WhitePixel(d,s);
  gcvals.fill_style = FillSolid;
  gc1 = XCreateGC(d,w,GCFillStyle|GCForeground|GCBackground,&gcvals);

  cmap = DefaultColormap(d,s);
  XParseColor(d, cmap, "#c0c0c0", &def);
  XAllocColor(d, cmap, &def);
  grey = def.pixel;

  gcvals.background = BlackPixel(d,s);
  gcvals.foreground = grey;
  gcvals.fill_style = FillSolid;
  gc2 = XCreateGC(d,w,GCFillStyle|GCForeground|GCBackground,&gcvals);

  daemon(0,0);

  while(1) {
    XMapRaised(d,w);
    XFillRectangle(d,w,gc1,0,0,SZ,SZ);
    XFlush(d);
    sleep(1);
    XFillRectangle(d,w,gc2,0,0,SZ,SZ);
    XFlush(d);
    sleep(1);
    XUnmapWindow(d,w);
    XFlush(d);
    sleep(INTERVAL);
  }

  return 0;
}

