#include <stdio.h>
#include <stdlib.h>
#include <X11/Xlib.h>

#define SZ 1
#define INTERVAL (5*60) /* five minutes */
//#define INTERVAL (1)

int main(int argc, char *argv[])
{
  Display *d;
  int s;
  int root;
  int w;
  XSetWindowAttributes attrs;
  int mask;
  GC gc1, gc2;
  XGCValues gcvals;
  Colormap cmap;
  XColor def;
  int grey;


  d = XOpenDisplay(NULL);
  if (d == NULL) {
    fprintf(stderr,"%s: Can't open display", argv[0]);
    exit(1);
  }

  s = DefaultScreen(d);
  root = RootWindow(d,s);

  attrs.override_redirect = True;
  mask = CWOverrideRedirect;
  w = XCreateWindow(d, root, 0, 0, SZ, SZ, 0, CopyFromParent, InputOutput,
                    CopyFromParent, mask, &attrs);

  gcvals.background = BlackPixel(d,s);
  gcvals.foreground = WhitePixel(d,s);
  gcvals.fill_style = FillSolid;
  gc1 = XCreateGC(d,w,GCFillStyle|GCForeground|GCBackground,&gcvals);

  cmap = DefaultColormap(d,s);
  XParseColor(d, cmap, "#c0c0c0", &def);
  XAllocColor(d, cmap, &def);
  grey = def.pixel;

  gcvals.background = BlackPixel(d,s);
  gcvals.foreground = grey;
  gcvals.fill_style = FillSolid;
  gc2 = XCreateGC(d,w,GCFillStyle|GCForeground|GCBackground,&gcvals);

  daemon(0,0);

  while(1) {
    XMapRaised(d,w);
    XFillRectangle(d,w,gc1,0,0,SZ,SZ);
    XFlush(d);
    sleep(1);
    XFillRectangle(d,w,gc2,0,0,SZ,SZ);
    XFlush(d);
    sleep(1);
    XUnmapWindow(d,w);
    XFlush(d);
    sleep(INTERVAL);
  }

  return 0;
}

