# @package      hubzero-mailgateway
# @file         deb.mk
# @author       David Benham <dbenham@purdue.edu>
# @copyright    Copyright (c) 2012-2015 HUBzero Foundation, LLC.
# @license      http://opensource.org/licenses/MIT MIT
#
# Copyright (c) 2012-2015 HUBzero Foundation, LLC.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# HUBzero is a registered trademark of HUBzero Foundation, LLC.
#

USRLIB=$(DESTDIR)/usr/lib
ETC=$(DESTDIR)/etc

all:
	@true

install:
	install --mode 0644 -D exim4/router/950_exim4-config_groupmessage  $(ETC)/exim4/conf.d/router/950_exim4-config_groupmessage 
	install --mode 0644 -D exim4/router/950_exim4-config_ticketcomment  $(ETC)/exim4/conf.d/router/950_exim4-config_ticketcomment
	install --mode 0644 -D exim4/router/955_exim4-config_supportmessage  $(ETC)/exim4/conf.d/router/955_exim4-config_supportmessage
	install --mode 0644 -D exim4/transport/40_exim4-config_hubgroupmessage_pipe  $(ETC)/exim4/conf.d/transport/40_exim4-config_hubgroupmessage_pipe
	install --mode 0644 -D exim4/transport/40_exim4-config_ticketcomment_pipe  $(ETC)/exim4/conf.d/transport/40_exim4-config_ticketcomment_pipe
	install --mode 0644 -D exim4/transport/45_exim4-config_support_email_pipe  $(ETC)/exim4/conf.d/transport/45_exim4-config_support_email_pipe
	install --mode 0755 -D python/mailproc.py $(USRLIB)/hubzero/bin/mailproc/mailproc.py
	install --mode 0755 -D python/processgroupforumpost.py $(USRLIB)/hubzero/bin/mailproc/processgroupforumpost.py
	install --mode 0755 -D python/processsupportemail.py $(USRLIB)/hubzero/bin/mailproc/processsupportemail.py
	install --mode 0755 -D python/processticketcomment.py $(USRLIB)/hubzero/bin/mailproc/processticketcomment.py
	install --mode 0755 -D python/filecopy.py $(USRLIB)/hubzero/bin/mailproc/filecopy.py
	install --mode 0755 -D python/process_emailbounces.py $(USRLIB)/hubzero/bin/mailproc/process_emailbounces.py
	install --mode 0644 -D exim4/router/975_exim4-config_emailbounces $(ETC)/exim4/conf.d/router/975_exim4-config_emailbounces
	install --mode 0644 -D exim4/transport/65_exim4-config_emailbounces_pipe $(ETC)/exim4/conf.d/transport/65_exim4-config_emailbounces_pipe

collectfiles:
	cp /etc/exim4/conf.d/router/950_exim4-config_groupmessage exim4/router/950_exim4-config_groupmessage
	cp /etc/exim4/conf.d/router/950_exim4-config_ticketcomment exim4/router/950_exim4-config_ticketcomment
	cp /etc/exim4/conf.d/router/955_exim4-config_supportmessage exim4/router/955_exim4-config_supportmessage
	cp /etc/exim4/conf.d/transport/40_exim4-config_hubgroupmessage_pipe exim4/transport/40_exim4-config_hubgroupmessage_pipe
	cp /etc/exim4/conf.d/transport/40_exim4-config_ticketcomment_pipe exim4/transport/40_exim4-config_ticketcomment_pipe
	cp /etc/exim4/conf.d/transport/45_exim4-config_support_email_pipe exim4/transport/45_exim4-config_support_email_pipe
	cp /usr/lib/hubzero/bin/mailproc/mailproc.py python/mailproc.py
	cp /usr/lib/hubzero/bin/mailproc/processgroupforumpost.py python/processgroupforumpost.py
	cp /usr/lib/hubzero/bin/mailproc/processsupportemail.py python/processsupportemail.py
	cp /usr/lib/hubzero/bin/mailproc/processticketcomment.py python/processticketcomment.py
	cp /usr/lib/hubzero/bin/mailproc/filecopy.py python/filecopy.py
	cp /etc/logrotate.d/hubmailgateway ./hubzero-mailgateway.logrotate.deb

uninstall:
	@true

postinst:
	install --mode 0744 --owner root --group root -D hubmailgateway /etc/logrotate.d/hubmailgateway

clean:
	@true

.PHONY: all install uninstall postinst clean
