module.exports = function(hg, done) {
	var getSql = function(id) {
		var sql = 'SELECT \'content pages\' AS domain, c.id, c.title, CAST(concat(coalesce(c.introtext, \'\'), coalesce(c.`fulltext`, \'\')) AS CHAR) AS body, ' + 
             'CAST(CASE ' +
                                       'WHEN ca.alias != \'\' OR c.alias != \'\' THEN ' +
                                              ' concat(' +
                                                       'CASE WHEN ca.alias != \'\' THEN concat(\'/\', ca.alias) ELSE \'\' END, ' +
                                                       'CASE WHEN c.alias != \'\' THEN concat(\'/\', c.alias) ELSE \'\' END ' +
                                               ') ' +
                                       'ELSE concat(\'/content/article/\', c.id) ' +
			'END AS CHAR) AS link, ' + 
			'publish_up AS date, NULL AS section, c.access, ' + 
		'(SELECT CAST(group_concat(ids.authorid separator \'\\n\') AS CHAR) FROM jos_author_assoc ids WHERE subtable = \'content\' AND subid = c.id ORDER BY ids.ordering) AS contributor_ids, ' +                                                
		'(SELECT CAST(group_concat(jto.tagid separator \'\\n\') AS CHAR) FROM jos_tags_object jto WHERE jto.tbl = \'content\' AND jto.objectid = c.id) AS tag_ids ' +                                                                             
		'FROM jos_content c ' +
		'LEFT JOIN jos_categories ca ON ca.id = c.catid ' +                                                                                                                                                                                 
		'WHERE (c.publish_up AND NOW() > c.publish_up) AND (NOT c.publish_down OR NOW() < c.publish_down) AND c.state = 1'; 
		return id ? sql + ' AND c.id = ' + (id * 1) : sql;
	};

	hg.event.observe('onResourcesLoaded', function(client) {
		var sql = getSql();

		client.query(sql, function(err, results) {                                                                                                                                                                                                                                   
			if (err) {
				throw err;
			}
			hg.log(results.length + ' content pages');
			results.forEach(hg.addWithCommonConnections);

			done();
			hg.event.emit('onContentLoaded', [client]);
		});
	});

	hg.event.observe('onUpdateContent', function(client, row) {
		var sql = getSql(row.id);
		client.query(sql, function(err, results) {
			if (err) {
				throw err;
			}
			if (!results.length) {
				hg.remove('content pages', row.id);
			}
			else {
				results.forEach(hg.addWithCommonConnections);
			}
		});
	});

	hg.event.observe('onInsertContent', function(client, row) {
		var sql = getSql(row.id);
		client.query(sql, function(err, results) {
			if (err) {
				throw err;
			}
			results.forEach(hg.addWithCommonConnections);
		});
	});

	hg.event.observe('onDeleteContent', function(client, row) {
		hg.remove('content pages', row.id);
	});
};

